/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.network;

import aqario.fowlplay.client.FowlPlayClient;
import aqario.fowlplay.client.render.debug.BirdDebugRenderer;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlay;
import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.pathfinder.Path;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class FowlPlayDebugPackets {
    public static void sendBirdData(BirdEntity bird) {
        FlyingBirdEntity flyingBird;
        boolean flying;
        if (!FowlPlay.isDebugUtilsLoaded() || bird.m_9236_().m_5776_() || !FowlPlayClient.DEBUG_BIRD) {
            return;
        }
        Brain brain = bird.m_6274_();
        String name = DebugEntityNameGenerator.m_179486_((Entity)bird);
        String inventory = "";
        Path path = null;
        boolean bl = flying = bird instanceof FlyingBirdEntity && (flyingBird = (FlyingBirdEntity)bird).isFlying();
        if (bird instanceof InventoryCarrier) {
            InventoryCarrier inventoryOwner = (InventoryCarrier)bird;
            String string = inventory = inventoryOwner.m_35311_().m_7983_() ? "" : inventoryOwner.m_35311_().toString();
        }
        if (BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26377_)) {
            path = (Path)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26377_);
        }
        ArrayList<String> trusting = new ArrayList<String>();
        if (bird instanceof TrustingBirdEntity) {
            TrustingBirdEntity trustingBird = (TrustingBirdEntity)bird;
            trustingBird.getTrustedUuids().forEach(uuid -> {
                Player player = bird.m_9236_().m_46003_(uuid);
                if (player != null) {
                    trusting.add(player.m_7755_().getString());
                } else {
                    trusting.add(uuid.toString());
                }
            });
        }
        List<String> activities = brain.m_147340_().stream().map(Activity::m_37998_).toList();
        List<String> behaviors = brain.m_21956_().stream().map(BehaviorControl::m_22566_).toList();
        List<String> memories = FowlPlayDebugPackets.getMemoryDescriptions((LivingEntity)bird, bird.m_9236_().m_46467_());
        String schedule = Optional.ofNullable(BuiltInRegistries.f_256962_.m_7981_((Object)brain.m_21932_())).map(ResourceLocation::m_135815_).orElse(null);
        Set<BlockPos> pois = Set.of();
        Set<BlockPos> potentialPois = Set.of();
        BirdDebugRenderer.BirdData data = new BirdDebugRenderer.BirdData(bird.m_20148_(), bird.m_19879_(), name, bird.m_21566_().getClass().getSimpleName(), bird.m_21573_().getClass().getSimpleName(), bird.m_21223_(), bird.m_21233_(), bird.m_20182_(), inventory, path, trusting, flying, bird.isAmbient(), Birds.isPerched(bird), activities, behaviors, memories, schedule, pois, potentialPois);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        data.write(buf);
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(FowlPlayClient.DEBUG_BIRD_ID, buf);
        FowlPlayDebugPackets.sendToAll((ServerLevel)bird.m_9236_(), packet);
    }

    private static List<String> getMemoryDescriptions(LivingEntity entity, long gameTime) {
        Map map = entity.m_6274_().m_147339_();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            MemoryModuleType memoryModuleType = (MemoryModuleType)entry.getKey();
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                ExpirableValue expirableValue = (ExpirableValue)optional.get();
                Object object = expirableValue.m_26319_();
                if (memoryModuleType == MemoryModuleType.f_26325_) {
                    long l = gameTime - (Long)object;
                    value = l + " ticks ago";
                } else if (expirableValue.m_26321_()) {
                    String desc = FowlPlayDebugPackets.getMemoryValueDescription((ServerLevel)entity.m_9236_(), object);
                    value = desc + " (ttl: " + expirableValue.m_148191_() + ")";
                } else {
                    value = FowlPlayDebugPackets.getMemoryValueDescription((ServerLevel)entity.m_9236_(), object);
                }
            } else {
                value = "-";
            }
            String memory = BuiltInRegistries.f_256784_.m_7981_((Object)memoryModuleType).m_135815_();
            list.add(memory + ": " + (String)value);
        }
        list.sort(String::compareTo);
        return list;
    }

    private static String getMemoryValueDescription(ServerLevel world, @Nullable Object object) {
        if (object == null) {
            return "-";
        }
        if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            return FowlPlayDebugPackets.getMemoryValueDescription(world, world.m_8791_(uuid));
        }
        if (object instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)object;
            return DebugEntityNameGenerator.m_179486_((Entity)entity2);
        }
        if (object instanceof Nameable) {
            Nameable nameable = (Nameable)object;
            return nameable.m_7755_().getString();
        }
        if (object instanceof WalkTarget) {
            WalkTarget walkTarget = (WalkTarget)object;
            return FowlPlayDebugPackets.getMemoryValueDescription(world, walkTarget.m_26420_());
        }
        if (object instanceof EntityTracker) {
            EntityTracker entityLookTarget = (EntityTracker)object;
            return FowlPlayDebugPackets.getMemoryValueDescription(world, entityLookTarget.m_147481_());
        }
        if (object instanceof GlobalPos) {
            GlobalPos globalPos = (GlobalPos)object;
            return FowlPlayDebugPackets.getMemoryValueDescription(world, globalPos.m_122646_());
        }
        if (object instanceof BlockPosTracker) {
            BlockPosTracker blockPosLookTarget = (BlockPosTracker)object;
            return FowlPlayDebugPackets.getMemoryValueDescription(world, blockPosLookTarget.m_6675_());
        }
        if (object instanceof DamageSource) {
            DamageSource damageSource = (DamageSource)object;
            Entity entity3 = damageSource.m_7639_();
            return entity3 == null ? object.toString() : FowlPlayDebugPackets.getMemoryValueDescription(world, entity3);
        }
        if (object instanceof Collection) {
            Collection iterable = (Collection)object;
            ArrayList list = Lists.newArrayList();
            iterable.forEach(o -> list.add(FowlPlayDebugPackets.getMemoryValueDescription(world, o)));
            return ((Object)list).toString();
        }
        if (object instanceof NearestVisibleLivingEntities) {
            NearestVisibleLivingEntities cache = (NearestVisibleLivingEntities)object;
            ArrayList list = Lists.newArrayList();
            cache.m_186128_(entity -> true).forEach(o -> list.add(FowlPlayDebugPackets.getMemoryValueDescription(world, o)));
            return ((Object)list).toString();
        }
        return object.toString();
    }

    private static void sendToAll(ServerLevel world, Packet<?> packet) {
        world.m_6907_().forEach(player -> {
            if (FowlPlayClient.DEBUG_BIRD) {
                player.f_8906_.m_9829_(packet);
            }
        });
    }
}

