/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SpeedModifiableBehaviour;
import aqario.fowlplay.common.entity.ai.navigation.BirdRandomPos;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_243;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetNonAirWalkTarget<E extends BirdEntity>
extends SpeedModifiableBehaviour<E> {
    private static final MemoryList MEMORIES = MemoryList.create(1).absent((class_4140<?>)class_4140.field_18445);
    protected Predicate<E> avoidWaterPredicate = entity -> true;
    protected CylindricalRadius radius = new CylindricalRadius(32, 16);
    protected BiPredicate<E, class_243> positionPredicate = (entity, pos) -> true;

    public SetNonAirWalkTarget<E> setRadius(int radius) {
        return this.setRadius(radius, radius);
    }

    public SetNonAirWalkTarget<E> setRadius(int xz, int y) {
        this.radius = new CylindricalRadius(xz, y);
        return this;
    }

    public SetNonAirWalkTarget<E> walkTargetPredicate(BiPredicate<E, class_243> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    public SetNonAirWalkTarget<E> dontAvoidWater() {
        return this.avoidWaterWhen(entity -> false);
    }

    public SetNonAirWalkTarget<E> avoidWaterWhen(Predicate<E> predicate) {
        this.avoidWaterPredicate = predicate;
        return this;
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        class_243 targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, (class_4140)class_4140.field_18445);
        } else {
            BrainUtils.setMemory(entity, (class_4140)class_4140.field_18445, (Object)new class_4142(targetPos, ((Float)this.speedModifier.apply(entity, targetPos)).floatValue(), 0));
        }
    }

    @Nullable
    protected class_243 getTargetPos(E entity) {
        if (this.avoidWaterPredicate.test(entity)) {
            return BirdRandomPos.getGround(entity, this.radius);
        }
        return BirdRandomPos.getNonAir(entity, this.radius);
    }
}

