/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SpeedModifiableBehaviour;
import aqario.fowlplay.common.entity.ai.navigation.BirdRandomPos;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_243;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetWaterWalkTarget<E extends BirdEntity>
extends SpeedModifiableBehaviour<E> {
    private static final MemoryList MEMORIES = MemoryList.create(1).absent((class_4140<?>)class_4140.field_18445);
    protected CylindricalRadius radius = new CylindricalRadius(32, 16);
    protected BiPredicate<E, class_243> positionPredicate = (entity, pos) -> true;

    public SetWaterWalkTarget<E> radius(int radius) {
        return this.radius(radius, radius);
    }

    public SetWaterWalkTarget<E> radius(int xz, int y) {
        this.radius = new CylindricalRadius(xz, y);
        return this;
    }

    public SetWaterWalkTarget<E> walkTargetPredicate(BiPredicate<E, class_243> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        class_243 targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, (class_4140)class_4140.field_18445);
        } else {
            BrainUtils.setMemory(entity, (class_4140)class_4140.field_18445, (Object)new class_4142(targetPos, ((Float)this.speedModifier.apply(entity, targetPos)).floatValue(), 0));
        }
    }

    @Nullable
    protected class_243 getTargetPos(E entity) {
        return BirdRandomPos.getWaterOrGround(entity, this.radius, this.radius);
    }
}

