/*
 * Decompiled with CFR 0.152.
 */
package net.orbit.block.entity.custom;

import java.util.stream.Collectors;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.orbit.block.entity.ImplementedInventory;
import net.orbit.block.entity.ModBlockEntities;
import net.orbit.block.entity.custom.PedestalRenderConfig;
import net.orbit.screen.custom.PedestalScreenHandler;
import org.jetbrains.annotations.Nullable;

public class PedestalBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278,
ExtendedScreenHandlerFactory<class_2338> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)99, (Object)class_1799.field_8037);
    private PedestalRenderConfig renderConfig = PedestalRenderConfig.defaultSingleItem();
    private float rotation = 0.0f;

    public PedestalBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.PEDESTAL_BE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2371<class_1799> getNonNullItems() {
        return this.inventory.stream().filter(itemStack -> !itemStack.method_7960()).collect(Collectors.toCollection(class_2371::method_10211));
    }

    public void push(class_1799 item) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (!((class_1799)this.inventory.get(i)).method_7960()) continue;
            this.inventory.set(i, (Object)item);
            break;
        }
    }

    public void pop() {
        for (int i = this.inventory.size() - 1; i >= 0; --i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            this.inventory.set(i, (Object)class_1799.field_8037);
            break;
        }
    }

    public class_1799 peek() {
        for (class_1799 item : this.getItems().reversed()) {
            if (item.method_7960()) continue;
            return item;
        }
        return class_1799.field_8037;
    }

    public boolean hasRoom() {
        for (class_1799 item : this.getItems()) {
            if (!item.method_7960()) continue;
            return true;
        }
        return false;
    }

    public float getRenderingRotation() {
        return this.rotation;
    }

    public void setRenderConfig(PedestalRenderConfig renderConfig) {
        this.renderConfig = renderConfig;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 3);
        }
    }

    public void updateConfigField(String fieldName, float value) {
        PedestalRenderConfig.Builder builder = PedestalRenderConfig.Builder.configToBuilder(this.renderConfig);
        switch (fieldName) {
            case "rotationSpeed": {
                builder.rotationSpeed(value);
                break;
            }
            case "baseHeight": {
                builder.baseHeight(value);
                break;
            }
            case "singleItemScale": {
                builder.singleItemScale(value);
                break;
            }
            case "levitationAmplitude": {
                builder.levitationAmplitude(value);
                break;
            }
            case "levitationSpeed": {
                builder.levitationSpeed(value);
                break;
            }
            case "radius": {
                builder.radius(value);
                break;
            }
            case "multiItemLevitationAmplitude": {
                builder.multiItemLevitationAmplitude(value);
            }
        }
        this.setRenderConfig(builder.build());
    }

    public void updateConfigField(String fieldName, boolean value) {
        PedestalRenderConfig.Builder builder = PedestalRenderConfig.Builder.configToBuilder(this.renderConfig);
        switch (fieldName) {
            case "forceRenderItem": {
                builder.forceRenderItem(value);
                break;
            }
            case "multiItemFancyRotation": {
                builder.multiItemFancyRotation(value);
            }
        }
        this.setRenderConfig(builder.build());
    }

    public void updateConfigField(String fieldName, class_243 value) {
        PedestalRenderConfig.Builder builder = PedestalRenderConfig.Builder.configToBuilder(this.renderConfig);
        switch (fieldName) {
            case "itemOffset": {
                builder.singleItemOffset(value);
                break;
            }
            case "itemRotation": {
                builder.itemRotation(value);
                break;
            }
            case "rotationStep": {
                builder.rotationStep(value);
            }
        }
        this.setRenderConfig(builder.build());
    }

    public PedestalRenderConfig getRenderConfig() {
        return this.renderConfig;
    }

    public void updateRotation() {
        this.updateRotation(0.5f);
    }

    public void updateRotation(float rotation) {
        this.rotation += rotation;
        if (this.rotation > 360.0f) {
            this.rotation = 0.0f;
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.inventory);
        this.writeRenderConfigToNbt(view);
        view.method_71464("rotation", this.rotation);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.inventory);
        this.renderConfig = this.readRenderConfigFromNbt(view);
        this.rotation = view.method_71423("rotation", 0.0f);
    }

    private void writeRenderConfigToNbt(class_11372 view) {
        view.method_71464("cfg_rotationSpeed", this.renderConfig.rotationSpeed());
        view.method_71464("cfg_baseHeight", this.renderConfig.baseHeight());
        view.method_71464("cfg_itemScale", this.renderConfig.itemScale());
        view.method_71464("cfg_levitationAmplitude", this.renderConfig.levitationAmplitude());
        view.method_71464("cfg_levitationSpeed", this.renderConfig.levitationSpeed());
        view.method_71464("cfg_radius", this.renderConfig.radius());
        view.method_71464("cfg_multiItemLevitationAmplitude", this.renderConfig.multiItemLevitationAmplitude());
        view.method_71472("cfg_forceRenderItem", this.renderConfig.forceRenderItem());
        view.method_71472("cfg_multiItemFancyRotation", this.renderConfig.multiItemFancyRotation());
        this.writeVec3dToNbt(view, "cfg_offset", this.renderConfig.itemOffset());
        this.writeVec3dToNbt(view, "cfg_rotation", this.renderConfig.itemRotation());
        this.writeVec3dToNbt(view, "cfg_rotStep", this.renderConfig.rotationStep());
    }

    private PedestalRenderConfig readRenderConfigFromNbt(class_11368 view) {
        return new PedestalRenderConfig.Builder().rotationSpeed(view.method_71423("cfg_rotationSpeed", 0.01f)).baseHeight(view.method_71423("cfg_baseHeight", 1.15f)).singleItemScale(view.method_71423("cfg_itemScale", 0.5f)).levitationAmplitude(view.method_71423("cfg_levitationAmplitude", 0.1f)).levitationSpeed(view.method_71423("cfg_levitationSpeed", 2.0f)).radius(view.method_71423("cfg_radius", 1.2f)).multiItemLevitationAmplitude(view.method_71423("cfg_multiItemLevitationAmplitude", 0.1f)).singleItemOffset(this.readVec3dFromNbt(view, "cfg_offset", PedestalRenderConfig.DEFAULT_SINGLE_ITEM_OFFSET)).itemRotation(this.readVec3dFromNbt(view, "cfg_rotation", PedestalRenderConfig.DEFAULT_SINGLE_ITEM_ROTATION)).rotationStep(this.readVec3dFromNbt(view, "cfg_rotStep", PedestalRenderConfig.DEFAULT_ROTATION_STEP)).forceRenderItem(view.method_71433("cfg_forceRenderItem", false)).multiItemFancyRotation(view.method_71433("cfg_multiItemFancyRotation", false)).build();
    }

    private void writeVec3dToNbt(class_11372 view, String prefix, class_243 vec) {
        view.method_71463(prefix + "X", vec.field_1352);
        view.method_71463(prefix + "Y", vec.field_1351);
        view.method_71463(prefix + "Z", vec.field_1350);
    }

    private class_243 readVec3dFromNbt(class_11368 view, String prefix, class_243 defaultValue) {
        return new class_243(view.method_71422(prefix + "X", defaultValue.field_1352), view.method_71422(prefix + "Y", defaultValue.field_1351), view.method_71422(prefix + "Z", defaultValue.field_1350));
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this);
        super.method_66473(pos, oldState);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        return false;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    protected void onViewerCountUpdate(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        class_2248 block = state.method_26204();
        world.method_8427(pos, block, 1, newViewerCount);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new PedestalScreenHandler(syncId, playerInventory, this.field_11867);
    }
}

