/*
 * Decompiled with CFR 0.152.
 */
package net.orbit.screen.custom;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_7842;
import net.minecraft.class_8710;
import net.orbit.network.UpdatePedestalBooleanPayload;
import net.orbit.network.UpdatePedestalFloatPayload;
import net.orbit.network.UpdatePedestalVec3dPayload;
import net.orbit.screen.custom.PedestalScreenHandler;
import net.orbit.screen.widget.NumericInputWidget;

@Environment(value=EnvType.CLIENT)
public class PedestalScreen
extends class_465<PedestalScreenHandler> {
    public static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"orbit_pedestals", (String)"textures/gui/pedestal/pedestal_gui.png");
    private class_243 currentOffset;
    private class_243 currentRotation;

    public PedestalScreen(PedestalScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.currentOffset = handler.getRenderConfig().itemOffset();
        this.currentRotation = handler.getRenderConfig().itemRotation();
    }

    protected void method_25426() {
        super.method_25426();
        int spacingY = 20;
        int spacingX = 10;
        int width = 150;
        int height = 18;
        int startY = (this.field_22790 - this.field_2779) / 2 - height - spacingY;
        int startX = (this.field_22789 - this.field_2792) / 2 - width / 2;
        int currentY = startY;
        this.method_37063((class_364)new NumericInputWidget(startX, currentY, width, height, (class_2561)class_2561.method_43470((String)"Rotation Speed"), ((PedestalScreenHandler)this.field_2797).getRenderConfig().rotationSpeed(), 0.0f, 1.0f, 0.01f, value -> this.sendConfigUpdate("rotationSpeed", value.floatValue())));
        this.method_37063((class_364)new NumericInputWidget(startX, currentY += spacingY, width, height, (class_2561)class_2561.method_43470((String)"Item Scale"), ((PedestalScreenHandler)this.field_2797).getRenderConfig().itemScale(), 0.1f, 3.0f, 0.1f, value -> this.sendConfigUpdate("singleItemScale", value.floatValue())));
        currentY += spacingY;
        currentY += spacingY;
        currentY = this.addVec3dFields(startX, currentY, width, height, spacingY, "Offset", this.currentOffset, -5.0f, 5.0f, 0.1f, "itemOffset", () -> this.currentOffset, newVec -> {
            this.currentOffset = newVec;
            this.sendConfigUpdate("itemOffset", this.currentOffset);
        });
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Force render item toggle"), action -> this.sendConfigUpdate("forceRenderItem", !((PedestalScreenHandler)this.field_2797).getRenderConfig().forceRenderItem())).method_46434(startX, currentY, width, height).method_46431());
        currentY += spacingY;
        currentY = startY;
        int column2X = startX + spacingX + width;
        this.method_37063((class_364)new NumericInputWidget(column2X, currentY, width, height, (class_2561)class_2561.method_43470((String)"Levitation Speed"), ((PedestalScreenHandler)this.field_2797).getRenderConfig().levitationSpeed(), 0.0f, 10.0f, 0.1f, value -> this.sendConfigUpdate("levitationSpeed", value.floatValue())));
        this.method_37063((class_364)new NumericInputWidget(column2X, currentY += spacingY, width, height, (class_2561)class_2561.method_43470((String)"Levitation Amplitude"), ((PedestalScreenHandler)this.field_2797).getRenderConfig().levitationAmplitude(), 0.0f, 10.0f, 0.1f, value -> this.sendConfigUpdate("levitationAmplitude", value.floatValue())));
        this.method_37063((class_364)new NumericInputWidget(column2X, currentY += spacingY, width, height, (class_2561)class_2561.method_43470((String)"Radius"), ((PedestalScreenHandler)this.field_2797).getRenderConfig().radius(), 0.0f, 5.0f, 0.1f, value -> this.sendConfigUpdate("radius", value.floatValue())));
        currentY += spacingY;
        currentY = this.addVec3dFields(column2X, currentY, width, height, spacingY, "Rotation", this.currentRotation, -180.0f, 180.0f, 1.0f, "itemRotation", () -> this.currentRotation, newVec -> {
            this.currentRotation = newVec;
            this.sendConfigUpdate("itemRotation", (class_243)newVec);
        });
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Multi item fancy rotation toggle"), action -> this.sendConfigUpdate("multiItemFancyRotation", !((PedestalScreenHandler)this.field_2797).getRenderConfig().multiItemFancyRotation())).method_46434(column2X, currentY, width, height).method_46431());
        currentY += spacingY;
    }

    private int addVec3dFields(int x, int y, int width, int height, int spacing, String labelPrefix, class_243 initialValue, float minValue, float maxValue, float step, String fieldName, Supplier<class_243> currentValueGetter, Consumer<class_243> onUpdate) {
        this.method_37063((class_364)new class_7842(x, y, width, 10, (class_2561)class_2561.method_43470((String)(labelPrefix + ":")), this.field_22793).method_48596().method_46438(0xFFFF55));
        this.method_37063((class_364)new NumericInputWidget(x, y += 12, width, height, (class_2561)class_2561.method_43470((String)"  X"), (float)initialValue.field_1352, minValue, maxValue, step, newX -> {
            class_243 current = (class_243)currentValueGetter.get();
            onUpdate.accept(new class_243((double)newX.floatValue(), current.field_1351, current.field_1350));
        }));
        this.method_37063((class_364)new NumericInputWidget(x, y += spacing, width, height, (class_2561)class_2561.method_43470((String)"  Y"), (float)initialValue.field_1351, minValue, maxValue, step, newY -> {
            class_243 current = (class_243)currentValueGetter.get();
            onUpdate.accept(new class_243(current.field_1352, (double)newY.floatValue(), current.field_1350));
        }));
        this.method_37063((class_364)new NumericInputWidget(x, y += spacing, width, height, (class_2561)class_2561.method_43470((String)"  Z"), (float)initialValue.field_1350, minValue, maxValue, step, newZ -> {
            class_243 current = (class_243)currentValueGetter.get();
            onUpdate.accept(new class_243(current.field_1352, current.field_1351, (double)newZ.floatValue()));
        }));
        return y += spacing;
    }

    private void sendConfigUpdate(String fieldName, float value) {
        ClientPlayNetworking.send((class_8710)new UpdatePedestalFloatPayload(((PedestalScreenHandler)this.field_2797).getBlockPos(), fieldName, value));
    }

    private void sendConfigUpdate(String fieldName, class_243 value) {
        ClientPlayNetworking.send((class_8710)new UpdatePedestalVec3dPayload(((PedestalScreenHandler)this.field_2797).getBlockPos(), fieldName, value));
    }

    private void sendConfigUpdate(String fieldName, boolean value) {
        ClientPlayNetworking.send((class_8710)new UpdatePedestalBooleanPayload(((PedestalScreenHandler)this.field_2797).getBlockPos(), fieldName, value));
    }

    protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
    }
}

