/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.imasillylittleguy.cnc.init.CncModBlockEntities;
import net.imasillylittleguy.cnc.init.CncModBlocks;
import net.imasillylittleguy.cnc.init.CncModEntities;
import net.imasillylittleguy.cnc.init.CncModItems;
import net.imasillylittleguy.cnc.init.CncModMenus;
import net.imasillylittleguy.cnc.init.CncModMobEffects;
import net.imasillylittleguy.cnc.init.CncModParticleTypes;
import net.imasillylittleguy.cnc.init.CncModSounds;
import net.imasillylittleguy.cnc.init.CncModTabs;
import net.imasillylittleguy.cnc.network.CncModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cnc")
public class CncMod {
    public static final Logger LOGGER = LogManager.getLogger(CncMod.class);
    public static final String MODID = "cnc";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public CncMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        CncModSounds.REGISTRY.register(modEventBus);
        CncModBlocks.REGISTRY.register(modEventBus);
        CncModBlockEntities.REGISTRY.register(modEventBus);
        CncModItems.REGISTRY.register(modEventBus);
        CncModEntities.REGISTRY.register(modEventBus);
        CncModTabs.REGISTRY.register(modEventBus);
        CncModVariables.ATTACHMENT_TYPES.register(modEventBus);
        CncModMobEffects.REGISTRY.register(modEventBus);
        CncModMenus.REGISTRY.register(modEventBus);
        CncModParticleTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class GuiSyncInit {
        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            CncMod.addNetworkMessage(GuiSyncMessage.TYPE, GuiSyncMessage.STREAM_CODEC, GuiSyncMessage::handleData);
        }
    }

    public record GuiSyncMessage(String editbox, String value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<GuiSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cnc", (String)"gui_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, GuiSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            GuiSyncMessage.writeComponent(buffer, (Component)Component.literal((String)message.editbox));
            GuiSyncMessage.writeComponent(buffer, (Component)Component.literal((String)message.value));
        }, buffer -> {
            String editbox = GuiSyncMessage.readComponent(buffer).getString();
            String value = GuiSyncMessage.readComponent(buffer).getString();
            return new GuiSyncMessage(editbox, value);
        });

        public CustomPacketPayload.Type<GuiSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(GuiSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND) {
                context.enqueueWork(() -> {
                    Screen currentScreen = Minecraft.getInstance().screen;
                    HashMap<String, EditBox> textFieldsMap = new HashMap<String, EditBox>();
                    if (currentScreen != null) {
                        Field[] fields;
                        for (Field field : fields = currentScreen.getClass().getDeclaredFields()) {
                            if (!EditBox.class.isAssignableFrom(field.getType())) continue;
                            try {
                                field.setAccessible(true);
                                EditBox textField = (EditBox)field.get(currentScreen);
                                if (textField == null) continue;
                                textFieldsMap.put(field.getName(), textField);
                            }
                            catch (IllegalAccessException ex) {
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                ex.printStackTrace(pw);
                                String exceptionAsString = sw.toString();
                                LOGGER.error(exceptionAsString);
                            }
                        }
                    }
                    if (textFieldsMap.get(message.editbox) != null) {
                        ((EditBox)textFieldsMap.get(message.editbox)).setValue(message.value);
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }

        private static Component readComponent(RegistryFriendlyByteBuf buffer) {
            return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
        }

        private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
        }
    }
}

