/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.entity;

import java.util.List;
import java.util.function.Predicate;
import net.imasillylittleguy.cnc.entity.BeaverEntity;
import net.imasillylittleguy.cnc.entity.CaribouEntity;
import net.imasillylittleguy.cnc.entity.CoyoteEntity;
import net.imasillylittleguy.cnc.entity.ElkEntity;
import net.imasillylittleguy.cnc.entity.GooseEntity;
import net.imasillylittleguy.cnc.entity.GreywolfEntity;
import net.imasillylittleguy.cnc.entity.MarmotEntity;
import net.imasillylittleguy.cnc.entity.MouseEntity;
import net.imasillylittleguy.cnc.entity.MuleDeerEntity;
import net.imasillylittleguy.cnc.entity.PitViperEntity;
import net.imasillylittleguy.cnc.entity.RattlesnakeEntity;
import net.imasillylittleguy.cnc.entity.RingtailEntity;
import net.imasillylittleguy.cnc.entity.SnakeEntity;
import net.imasillylittleguy.cnc.entity.TurkeyEntity;
import net.imasillylittleguy.cnc.entity.WhitetailEntity;
import net.imasillylittleguy.cnc.init.CncModEntities;
import net.imasillylittleguy.cnc.init.CncModItems;
import net.imasillylittleguy.cnc.procedures.BabyHitboxProcedure;
import net.imasillylittleguy.cnc.procedures.CougarAISittingConditionsProcedure;
import net.imasillylittleguy.cnc.procedures.CougarNaturalEntitySpawningConditionProcedure;
import net.imasillylittleguy.cnc.procedures.CougarOnEntityTickUpdateProcedure;
import net.imasillylittleguy.cnc.procedures.CougarRightClickedOnEntityProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CougarEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(CougarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(CougarEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(CougarEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_sitting = SynchedEntityData.defineId(CougarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public CougarEntity(EntityType<CougarEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"cougar");
        builder.define(DATA_sitting, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, BeaverEntity.class, false, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, WhitetailEntity.class, false, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, MuleDeerEntity.class, false, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, ElkEntity.class, false, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, CaribouEntity.class, false, false));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, GooseEntity.class, false, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, TurkeyEntity.class, false, false));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, MouseEntity.class, false, false));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, MarmotEntity.class, false, false));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, PitViperEntity.class, false, false));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, RattlesnakeEntity.class, false, false));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, SnakeEntity.class, false, false));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, false, false));
        this.targetSelector.addGoal(14, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, false, false));
        this.targetSelector.addGoal(15, (Goal)new NearestAttackableTargetGoal((Mob)this, Cow.class, false, false));
        this.targetSelector.addGoal(16, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, false, false));
        this.targetSelector.addGoal(17, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false, false));
        this.targetSelector.addGoal(18, (Goal)new NearestAttackableTargetGoal((Mob)this, Goat.class, false, false));
        this.targetSelector.addGoal(19, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(20, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false));
        this.targetSelector.addGoal(21, (Goal)new NearestAttackableTargetGoal((Mob)this, Cat.class, false, false));
        this.targetSelector.addGoal(22, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, false, false));
        this.targetSelector.addGoal(23, (Goal)new NearestAttackableTargetGoal((Mob)this, CoyoteEntity.class, false, false));
        this.targetSelector.addGoal(24, (Goal)new NearestAttackableTargetGoal((Mob)this, GreywolfEntity.class, false, false));
        this.targetSelector.addGoal(25, (Goal)new NearestAttackableTargetGoal((Mob)this, RingtailEntity.class, false, false));
        this.goalSelector.addGoal(26, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(27, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(28, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(29, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(30, (Goal)new FollowParentGoal((Animal)this, 0.8){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(31, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CncModItems.RAW_VENISON.get()}), true){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(32, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(33, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(34, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(35, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CougarEntity.this.getX();
                double y = CougarEntity.this.getY();
                double z = CougarEntity.this.getZ();
                CougarEntity entity = CougarEntity.this;
                Level world = CougarEntity.this.level();
                return super.canContinueToUse() && CougarAISittingConditionsProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.cougar.idle"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wolf.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.cougar.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.cougar.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("Datasitting", ((Boolean)this.entityData.get(DATA_sitting)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datasitting")) {
            this.entityData.set(DATA_sitting, (Object)compound.getBoolean("Datasitting"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        CougarEntity entity = this;
        Level world = this.level();
        CougarRightClickedOnEntityProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        CougarOnEntityTickUpdateProcedure.execute((Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        CougarEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return super.getDefaultDimensions(pose).scale((float)BabyHitboxProcedure.execute((Entity)entity));
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        CougarEntity retval = (CougarEntity)((EntityType)CncModEntities.COUGAR.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return List.of((Item)CncModItems.RAW_VENISON.get()).contains(stack.getItem());
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CncModEntities.COUGAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return CougarNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isAggressive() || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cougar.walk"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cougar.run"));
            }
            if (this.isAggressive() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cougar.run"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cougar.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.cougar.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

