/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.network;

import java.util.function.Supplier;
import net.imasillylittleguy.cnc.CncMod;
import net.imasillylittleguy.cnc.client.toasts.FieldGuideNotificationToast;
import net.imasillylittleguy.cnc.client.toasts.MobsDisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ShowToastMessage {
    private final String mobType;

    public ShowToastMessage(String mobType) {
        this.mobType = mobType;
    }

    public ShowToastMessage(FriendlyByteBuf buffer) {
        this.mobType = buffer.m_130277_();
    }

    public static void buffer(ShowToastMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.mobType);
    }

    public static void handler(ShowToastMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ShowToastMessage.handleClientSide(message.mobType);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSide(String mobType) {
        MobsDisplayInfo displayInfo;
        switch (mobType) {
            case "elk": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.ELK;
                break;
            }
            case "wendigo": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WENDIGO;
                break;
            }
            case "coyote": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.COYOTE;
                break;
            }
            case "timber_wolf": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.TIMBER_WOLF;
                break;
            }
            case "white_tailed_deer": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WHITE_TAILED_DEER;
                break;
            }
            case "skinwalker": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SKINWALKER;
                break;
            }
            case "cougar": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.COUGAR;
                break;
            }
            case "wolverine": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WOLVERINE;
                break;
            }
            case "chupacabra": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.CHUPACABRA;
                break;
            }
            case "ringtail": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.RINGTAIL;
                break;
            }
            case "giant_boar": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.GIANT_BOAR;
                break;
            }
            case "squonk": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SQUONK;
                break;
            }
            case "goose": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.GOOSE;
                break;
            }
            case "black_bear": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.BLACK_BEAR;
                break;
            }
            case "beaver": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.BEAVER;
                break;
            }
            case "howler": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.HOWLER;
                break;
            }
            case "sasquatch": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SASQUATCH;
                break;
            }
            case "mouse": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.MOUSE;
                break;
            }
            case "snake": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SNAKE;
                break;
            }
            case "rattlesnake": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.RATTLESNAKE;
                break;
            }
            case "pit_viper": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.PIT_VIPER;
                break;
            }
            case "wechuge": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WECHUGE;
                break;
            }
            case "turkey": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.TURKEY;
                break;
            }
            case "caribou": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.CARIBOU;
                break;
            }
            case "skunk": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SKUNK;
                break;
            }
            case "marmot": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.MARMOT;
                break;
            }
            case "mule_deer": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.MULE_DEER;
                break;
            }
            default: {
                MobsDisplayInfo mobsDisplayInfo = displayInfo = null;
            }
        }
        if (displayInfo != null) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new FieldGuideNotificationToast(displayInfo));
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CncMod.addNetworkMessage(ShowToastMessage.class, ShowToastMessage::buffer, ShowToastMessage::new, ShowToastMessage::handler);
    }
}

