/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class KKLevelUpTrigger
implements CriterionTrigger<Instance> {
    public static KKLevelUpTrigger TRIGGER_LEVELUP;
    private static final ResourceLocation ID;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void m_6467_(PlayerAdvancements pPlayerAdvancements, CriterionTrigger.Listener<Instance> pListener) {
        Listeners listeners = this.listeners.get(pPlayerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(pPlayerAdvancements);
            this.listeners.put(pPlayerAdvancements, listeners);
        }
        listeners.add(pListener);
    }

    public void m_6468_(PlayerAdvancements pPlayerAdvancements, CriterionTrigger.Listener<Instance> pListener) {
        Listeners listeners = this.listeners.get(pPlayerAdvancements);
        if (listeners != null) {
            listeners.remove(pListener);
            if (listeners.isEmpty()) {
                this.listeners.remove(pPlayerAdvancements);
            }
        }
    }

    public void m_5656_(PlayerAdvancements pPlayerAdvancements) {
        this.listeners.remove(pPlayerAdvancements);
    }

    public Instance createInstance(JsonObject pJson, DeserializationContext pContext) {
        int lvl = pJson.has("lvl") ? GsonHelper.m_13927_((JsonObject)pJson, (String)"lvl") : 0;
        return new Instance(lvl);
    }

    public void trigger(ServerPlayer player, int lvl) {
        Listeners listeners = this.listeners.get(player.m_8960_());
        if (listeners != null) {
            listeners.trigger((Player)player, lvl);
        }
    }

    static {
        ID = new ResourceLocation("kingdomkeys", "level_up");
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        Listeners(PlayerAdvancements playerAdvancements) {
            this.playerAdvancements = playerAdvancements;
        }

        boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Player player, int lvl) {
            List list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener1 : list) {
                    if (!((Instance)listener1.m_13685_()).matches(lvl)) continue;
                    listener1.m_13686_(this.playerAdvancements);
                }
            }
        }
    }

    static class Instance
    implements CriterionTriggerInstance {
        int lvl;

        public Instance(int lvl) {
            this.lvl = lvl;
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public boolean matches(int lvl) {
            return lvl >= this.lvl;
        }

        public JsonObject m_7683_(SerializationContext pConditions) {
            JsonObject jsonobject = new JsonObject();
            if (this.lvl != 0) {
                jsonobject.addProperty("lvl", (Number)this.lvl);
            }
            return jsonobject;
        }
    }
}

