/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.BlastBloxEntity;
import online.kingdomkeys.kingdomkeys.util.SetBlockStateFlags;

public class BlastBloxBlock
extends BaseBlock {
    private static final VoxelShape collisionShape = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlastBloxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_() && worldIn.m_276867_(pos)) {
            this.explode(worldIn, pos);
            worldIn.m_7471_(pos, false);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.m_276867_(pos)) {
            this.explode(worldIn, pos);
            worldIn.m_7471_(pos, false);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_() && !player.m_7500_() && player.m_21205_().m_41720_() != Items.f_42402_) {
            this.explode(worldIn, pos);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        super.m_7592_(worldIn, pos, explosionIn);
    }

    public void explode(Level world, BlockPos pos) {
        this.explode(world, pos, null);
    }

    private void explode(Level world, BlockPos pos, @Nullable LivingEntity igniter) {
        if (!world.f_46443_) {
            BlastBloxEntity entity = new BlastBloxEntity((EntityType)ModEntities.TYPE_BLAST_BLOX.get(), world, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, igniter);
            world.m_7967_((Entity)entity);
            world.m_6263_((Player)null, (double)entity.m_20183_().m_123341_(), (double)entity.m_20183_().m_123342_(), (double)entity.m_20183_().m_123343_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        ItemStack held = player.m_21205_();
        Item item = held.m_41720_();
        if (item != Items.f_42402_) {
            this.explode(worldIn, pos, (LivingEntity)player);
            worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), SetBlockStateFlags.BLOCK_UPDATE.getValue() | SetBlockStateFlags.SEND_TO_CLIENT.getValue() | SetBlockStateFlags.RERENDER_ON_MAIN.getValue());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item != Items.f_42409_ && item != Items.f_42613_) {
            return super.m_6227_(state, worldIn, pos, player, hand, hit);
        }
        this.explode(worldIn, pos, (LivingEntity)player);
        worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), SetBlockStateFlags.BLOCK_UPDATE.getValue() | SetBlockStateFlags.SEND_TO_CLIENT.getValue() | SetBlockStateFlags.RERENDER_ON_MAIN.getValue());
        if (item == Items.f_42409_) {
            stack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(hand));
        } else {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_) {
            this.explode(worldIn, pos, entityIn instanceof LivingEntity ? (LivingEntity)entityIn : null);
            worldIn.m_7471_(pos, false);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return collisionShape;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.explode(world, pos, entity instanceof LivingEntity ? (LivingEntity)entity : null);
        world.m_7471_(pos, false);
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }
}

