/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCDeleteSavePointScreenshot;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateSavePoints;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public class SavePointBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    private static final VoxelShape collisionShape = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0);
    public static final EnumProperty<SavePointStorage.SavePointType> TIER = EnumProperty.m_61587_((String)"tier", SavePointStorage.SavePointType.class);

    public SavePointBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TIER, (Comparable)((Object)SavePointStorage.SavePointType.NORMAL)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockItem blockItem;
        ItemStack held = pContext.m_43722_();
        Item item = held.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() == ModBlocks.savepoint.get() && held.m_41783_() != null && held.m_41783_().m_128441_("tier")) {
            return (BlockState)this.m_49966_().m_61124_(TIER, (Comparable)((Object)SavePointStorage.SavePointType.valueOf(held.m_41783_().m_128461_("tier"))));
        }
        return (BlockState)this.m_49966_().m_61124_(TIER, (Comparable)((Object)SavePointStorage.SavePointType.NORMAL));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_("tier") && pTooltip.get(0) != null) {
            if (pStack.m_41783_().m_128461_("tier").equals(SavePointStorage.SavePointType.LINKED.m_7912_().toUpperCase())) {
                pTooltip.set(0, (Component)Component.m_237115_((String)"block.kingdomkeys.linked_savepoint"));
            } else if (pStack.m_41783_().m_128461_("tier").equals(SavePointStorage.SavePointType.WARP.m_7912_().toUpperCase())) {
                pTooltip.set(0, (Component)Component.m_237115_((String)"block.kingdomkeys.warp_point"));
            }
        }
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{TIER});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return collisionShape;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return collisionShape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pNewState.m_60734_() != this && pState.m_61143_(TIER) != SavePointStorage.SavePointType.NORMAL && !pLevel.m_5776_()) {
            SavepointTileEntity te = (SavepointTileEntity)pLevel.m_7702_(pPos);
            SavePointStorage storage = SavePointStorage.getStorage(pLevel.m_7654_());
            if (storage.savePointRegistered(te.getID())) {
                SavePointStorage.SavePoint removed = storage.getSavePoint(te.getID());
                storage.removeSavePoint(te.getID());
                for (Level level : pLevel.m_7654_().m_129785_()) {
                    for (Player playerFromList : level.m_6907_()) {
                        PacketHandler.sendTo(new SCUpdateSavePoints(storage.getDiscoveredSavePoints(playerFromList)), (ServerPlayer)playerFromList);
                        PacketHandler.sendTo(new SCDeleteSavePointScreenshot(removed.name(), removed.id()), (ServerPlayer)playerFromList);
                    }
                }
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(handIn);
        if (!stack.m_41619_() && (blockEntity = worldIn.m_7702_(pos)) instanceof SavepointTileEntity) {
            String list;
            SavepointTileEntity savepoint = (SavepointTileEntity)blockEntity;
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            switch ((SavePointStorage.SavePointType)((Object)state.m_61143_(TIER))) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NORMAL: {
                    String string = ModConfigs.savePointRecovers;
                    break;
                }
                case LINKED: {
                    String string = ModConfigs.linkedSavePointRecovers;
                    break;
                }
                case WARP: {
                    String string = list = ModConfigs.warpPointRecovers;
                }
            }
            if (stack.m_41720_() == ModItems.orichalcum.get()) {
                if (savepoint.getHeal() > 1 && list.contains("HP")) {
                    stack.m_41774_(1);
                    savepoint.setHeal(Math.max(savepoint.getHeal() - 4, 1));
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.healing", new Object[0]), Utils.getSavepointPercent(savepoint.getHeal())}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.healing", new Object[0])}), true);
                }
            } else if (stack.m_41720_() == ModItems.illusory_crystal.get()) {
                if (savepoint.getMagic() > 1 && list.contains("MP")) {
                    stack.m_41774_(1);
                    savepoint.setMagic(Math.max(savepoint.getMagic() - 4, 1));
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.magic", new Object[0]), Utils.getSavepointPercent(savepoint.getMagic())}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.magic", new Object[0])}), true);
                }
            } else if (stack.m_41720_() == ModItems.hungry_crystal.get()) {
                if (savepoint.getHunger() > 1 && list.contains("HUNGER")) {
                    stack.m_41774_(1);
                    savepoint.setHunger(Math.max(savepoint.getHunger() - 4, 1));
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.feed", new Object[0]), Utils.getSavepointPercent(savepoint.getHunger())}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.feed", new Object[0])}), true);
                }
            } else if (stack.m_41720_() == ModItems.remembrance_crystal.get()) {
                if (savepoint.getFocus() > 1 && list.contains("FOCUS")) {
                    stack.m_41774_(1);
                    savepoint.setFocus(Math.max(savepoint.getFocus() - 4, 1));
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.focus", new Object[0]), Utils.getSavepointPercent(savepoint.getFocus())}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.focus", new Object[0])}), true);
                }
            } else if (stack.m_41720_() == ModItems.evanescent_crystal.get()) {
                if (savepoint.getDrive() > 1 && list.contains("DRIVE")) {
                    stack.m_41774_(1);
                    savepoint.setDrive(Math.max(savepoint.getDrive() - 4, 1));
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.drive", new Object[0]), Utils.getSavepointPercent(savepoint.getDrive())}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.drive", new Object[0])}), true);
                }
            } else if (stack.m_41720_() == ModItems.orichalcumplus.get()) {
                if (state.m_61143_(TIER) != SavePointStorage.SavePointType.WARP) {
                    stack.m_41774_(1);
                    BlockState newState = state.m_61143_(TIER) == SavePointStorage.SavePointType.NORMAL ? (BlockState)state.m_61124_(TIER, (Comparable)((Object)SavePointStorage.SavePointType.LINKED)) : (BlockState)state.m_61124_(TIER, (Comparable)((Object)SavePointStorage.SavePointType.WARP));
                    worldIn.m_46597_(pos, newState);
                    player.m_5661_((Component)Component.m_237110_((String)"savepoint.upgrade_type", (Object[])new Object[]{((SavePointStorage.SavePointType)((Object)newState.m_61143_(TIER))).m_7912_()}), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"savepoint.max_upgrade"), true);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof Player) {
            BlockEntity blockEntity;
            IPlayerCapabilities playerData;
            Player player = (Player)entity;
            if (!world.m_5776_() && (playerData = ModCapabilities.getPlayer(player)) != null && (blockEntity = world.m_7702_(pos)) instanceof SavepointTileEntity) {
                String list;
                SavepointTileEntity savepoint = (SavepointTileEntity)blockEntity;
                switch ((SavePointStorage.SavePointType)((Object)state.m_61143_(TIER))) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORMAL: {
                        String string = ModConfigs.savePointRecovers;
                        break;
                    }
                    case LINKED: {
                        String string = ModConfigs.linkedSavePointRecovers;
                        break;
                    }
                    case WARP: {
                        String string = list = ModConfigs.warpPointRecovers;
                    }
                }
                if (savepoint.getHeal() == 0 || savepoint.getHunger() == 0 || savepoint.getFocus() == 0 || savepoint.getMagic() == 0 || savepoint.getDrive() == 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"ERROR, this is probably an old savepoint, break and place it again to correct it"), true);
                } else {
                    if (list.contains("HP") && entity.f_19797_ % savepoint.getHeal() == 0 && player.m_21223_() < player.m_21233_()) {
                        player.m_5634_(1.0f);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("HUNGER") && entity.f_19797_ % savepoint.getHunger() == 0 && player.m_36324_().m_38702_() < 20) {
                        player.m_36324_().m_38707_(1, 1.0f);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("MP") && entity.f_19797_ % savepoint.getMagic() == 0 && playerData.getMP() < playerData.getMaxMP()) {
                        playerData.addMP(1.0);
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("FOCUS") && entity.f_19797_ % savepoint.getFocus() == 0 && playerData.getFocus() < playerData.getMaxFocus()) {
                        playerData.addFocus(1.0);
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("DRIVE") && entity.f_19797_ % savepoint.getDrive() == 0 && playerData.getDP() < playerData.getMaxDP()) {
                        playerData.addDP(5.0);
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
                        this.showParticles(player, world, pos);
                    }
                }
            }
        }
        super.m_7892_(state, world, pos, entity);
    }

    public void showParticles(Player player, Level world, BlockPos pos) {
        if (player.f_19797_ % 5 == 0) {
            player.m_5496_((SoundEvent)ModSounds.savepoint.get(), 1.0f, 1.0f);
        }
        world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.2, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.2, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.8, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.8, 0.0, 0.0, 0.0);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModEntities.TYPE_SAVEPOINT.get() ? SavepointTileEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModEntities.TYPE_SAVEPOINT.get()).m_155264_(pPos, pState);
    }
}

