/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.gui.SavePointScreen;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScreenshotManager {
    private static boolean takeScreenshot = false;
    private static String name;
    private static UUID uuid;
    public static int width;
    public static int height;

    public static String getFileNameString(String savePointName, UUID savePointID) {
        String nameNoInvalid = savePointName.replaceAll("[\\\\/:*?\"<>|]", "_").toLowerCase();
        return nameNoInvalid + "_" + savePointID.toString() + ".png";
    }

    public static File getScreenshotFile(String savePointName, UUID savePointID) {
        Path screenshotsDir = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "kingdomkeys/save_points/");
        String fileName = ScreenshotManager.getFileNameString(savePointName, savePointID);
        File screenshotFile = new File(screenshotsDir.toFile(), fileName);
        if (screenshotFile.exists() && screenshotFile.isFile()) {
            return screenshotFile;
        }
        return null;
    }

    public static void screenshot(String savePointName, UUID savePointID) {
        name = savePointName;
        uuid = savePointID;
        takeScreenshot = true;
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
    }

    public static boolean isTakingScreenshot() {
        return takeScreenshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeScreenshot(String savePointName, UUID savePointID) {
        Path p = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "kingdomkeys/save_points");
        String fileName = ScreenshotManager.getFileNameString(savePointName, savePointID);
        File fileToCreate = new File(p.toFile(), fileName);
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NativeImage image = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        int i = image.m_84982_();
        int j = image.m_85084_();
        int k = 0;
        int l = 0;
        if (i > j) {
            k = (i - j) / 2;
            i = j;
        } else {
            l = (j - i) / 2;
            j = i;
        }
        NativeImage resized = new NativeImage(width, height, false);
        image.m_85034_(k, l, i, j, resized);
        try {
            resized.m_85056_(fileToCreate);
            KingdomKeys.LOGGER.info("Saved save point screenshot " + fileName);
        }
        catch (IOException ioexception) {
            KingdomKeys.LOGGER.warn("Couldn't save screenshot", (Throwable)ioexception);
        }
        finally {
            image.close();
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null && takeScreenshot) {
            Screen screen;
            ScreenshotManager.takeScreenshot(name, uuid);
            takeScreenshot = false;
            Minecraft.m_91087_().f_91066_.f_92062_ = false;
            if (Minecraft.m_91087_().f_91080_ != null && (screen = Minecraft.m_91087_().f_91080_) instanceof SavePointScreen) {
                SavePointScreen savePointScreen = (SavePointScreen)screen;
                savePointScreen.loadSavePointScreenshots();
            }
        }
    }

    @SubscribeEvent
    public static void renderOverlays(RenderGuiOverlayEvent.Pre event) {
        event.setCanceled(ScreenshotManager.isTakingScreenshot());
    }

    static {
        width = 320;
        height = 180;
    }
}

