/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.client.ScreenshotManager;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.CheckboxButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.DropDownButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.EditBoxLength;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.SavePointButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.SavePointExtrasButton;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCreateSavePoint;
import online.kingdomkeys.kingdomkeys.network.cts.CSSavePointTP;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;
import org.jetbrains.annotations.NotNull;

public class SavePointScreen
extends MenuBackground {
    SavepointTileEntity tileEntity;
    public Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints;
    public Map<UUID, Screenshot> savePointScreenshots = new HashMap<UUID, Screenshot>();
    boolean create;
    public UUID hovered = null;
    private final int SAVE = 0;
    private final int RENAME = 1;
    private final int RETAKE = 2;
    int sorting = 0;
    int ordering = 0;
    EditBoxLength nameField;
    MenuButton save;
    MenuScrollBar bar;
    DropDownButton sortDropDown;
    DropDownButton orderDropDown;
    CheckboxButton setGlobal;
    SavePointExtrasButton rename;
    SavePointExtrasButton retake;
    SavePointStorage.SavePointType type;
    SavePointStorage.SavePoint current;
    final int recent = 0;
    final int name = 1;
    final int dimension = 2;
    final int owner = 3;

    public SavePointScreen(SavepointTileEntity tileEntity, Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints, boolean create) {
        super(create ? "gui.save.create.title" : ((SavePointStorage.SavePoint)savePoints.get(tileEntity.getID()).getFirst()).name(), Color.green);
        this.tileEntity = tileEntity;
        this.type = (SavePointStorage.SavePointType)((Object)tileEntity.m_58900_().m_61143_(SavePointBlock.TIER));
        this.savePoints = savePoints;
        this.create = create;
        savePoints.forEach((uuid, savePoint) -> this.savePointScreenshots.put((UUID)uuid, new Screenshot(Minecraft.m_91087_().f_90987_, new ResourceLocation("kingdomkeys", "save_points/" + String.valueOf(uuid)))));
        if (!create) {
            this.current = (SavePointStorage.SavePoint)savePoints.get(tileEntity.getID()).getFirst();
            if (ScreenshotManager.getScreenshotFile(this.current.name(), this.current.id()) == null) {
                ScreenshotManager.screenshot(this.current.name(), this.current.id());
            }
            this.loadSavePointScreenshots();
        }
        this.shouldCloseOnMenu = false;
    }

    public void updateSavePointsFromServer(Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints) {
        if (!savePoints.containsKey(this.tileEntity.getID())) {
            this.m_7379_();
        }
        if (!this.create) {
            this.current = (SavePointStorage.SavePoint)savePoints.get(this.tileEntity.getID()).getFirst();
            this.savePoints = savePoints;
            this.f_169369_.clear();
            this.m_6702_().clear();
            this.m_7856_();
            this.updateButtons();
            savePoints.forEach((uuid, savePoint) -> this.savePointScreenshots.put((UUID)uuid, new Screenshot(Minecraft.m_91087_().f_90987_, new ResourceLocation("kingdomkeys", "save_points/" + String.valueOf(uuid)))));
            this.loadSavePointScreenshots();
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (!ScreenshotManager.isTakingScreenshot()) {
            this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
            boolean mouseOverCurrent = false;
            for (Renderable renderable : this.f_169369_) {
                SavePointButton savePointButton;
                if (renderable instanceof SavePointButton && (savePointButton = (SavePointButton)renderable).getDestination().equals(this.tileEntity.getID())) {
                    mouseOverCurrent = savePointButton.isMouseOverInactive(mouseX, mouseY);
                }
                if (renderable instanceof SavePointButton || renderable == this.rename || renderable == this.retake) {
                    gui.m_280588_(0, (int)this.topBarHeight, this.f_96543_, (int)(this.topBarHeight + this.middleHeight));
                    renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
                    gui.m_280618_();
                    continue;
                }
                if (renderable instanceof DropDownButton) continue;
                renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
            }
            if (this.rename != null) {
                this.rename.f_93624_ = mouseOverCurrent;
            }
            if (this.retake != null) {
                this.retake.f_93624_ = mouseOverCurrent;
            }
            if (this.orderDropDown != null && this.sortDropDown != null) {
                this.orderDropDown.m_88315_(gui, mouseX, mouseY, partialTicks);
                gui.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
                this.sortDropDown.m_88315_(gui, mouseX, mouseY, partialTicks);
            }
        }
        if (this.create) {
            String text = Utils.translateToLocal("gui.save.create.prompt", new Object[0]);
            Font font = this.f_96541_.f_91062_;
            int n = this.f_96543_ / 2 - this.f_96541_.f_91062_.m_92895_(text) / 2;
            int n2 = this.f_96544_ / 2;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font, text, n, n2 - 9 / 2 - 60, Color.WHITE.getRGB());
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.create && this.save.f_93623_ && keyCode == 257) {
            this.action(0);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.savePointScreenshots.forEach((uuid, screenshot) -> screenshot.close());
        super.m_7379_();
    }

    private void action(int id) {
        switch (id) {
            case 0: {
                File currentName;
                if (this.nameField.getValue().isEmpty()) break;
                if (this.savePointScreenshots.containsKey(this.tileEntity.getID()) && (currentName = this.getSavePointScreenshots().get(this.tileEntity.getID())) != null) {
                    if (currentName.delete()) {
                        KingdomKeys.LOGGER.info("Deleted save point screenshot: {}", (Object)currentName.getName());
                    } else {
                        KingdomKeys.LOGGER.error("Failed to delete save point screenshot: {}", (Object)currentName.getName());
                    }
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                PacketHandler.sendToServer(new CSCreateSavePoint(this.tileEntity, this.nameField.getValue(), (Player)player, this.setGlobal.isChecked()));
                this.create = false;
                this.nameField.f_93624_ = false;
                this.save.f_93624_ = false;
                this.setGlobal.f_93624_ = false;
                ScreenshotManager.screenshot(this.nameField.getValue(), this.tileEntity.getID());
                this.title = Component.m_237113_((String)this.nameField.getValue());
                break;
            }
            case 1: {
                this.create = true;
                this.sortDropDown = null;
                this.f_169369_.clear();
                this.m_6702_().clear();
                this.m_7856_();
                break;
            }
            case 2: {
                ScreenshotManager.screenshot(((SavePointStorage.SavePoint)this.savePoints.get(this.tileEntity.getID()).getFirst()).name(), this.tileEntity.getID());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.create) {
            this.save.f_93623_ = !this.nameField.getValue().isEmpty();
        }
    }

    public void clickSavePoint(UUID id) {
        PacketHandler.sendToServer(new CSSavePointTP(this.tileEntity.getID(), id));
        this.m_7379_();
    }

    public void loadSavePointScreenshots() {
        long timeStarted = System.currentTimeMillis();
        KingdomKeys.LOGGER.debug("Loading screenshots...");
        Map<UUID, File> files = this.getSavePointScreenshots();
        KingdomKeys.LOGGER.debug("Got files in {}ms", (Object)(System.currentTimeMillis() - timeStarted));
        if (!files.isEmpty()) {
            files.forEach((uuid, file) -> {
                try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    long timeStartedReading = System.currentTimeMillis();
                    this.savePointScreenshots.get(uuid).upload(NativeImage.m_85058_((InputStream)inputStream));
                    KingdomKeys.LOGGER.debug("Read image for {} in {}ms", (Object)file.getName(), (Object)(System.currentTimeMillis() - timeStartedReading));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        KingdomKeys.LOGGER.debug("Screenshots loaded in {}ms", (Object)(System.currentTimeMillis() - timeStarted));
    }

    Map<UUID, File> getSavePointScreenshots() {
        Map<UUID, File> files;
        File[] fileArray;
        HashMap<UUID, File> fileMap = new HashMap<UUID, File>();
        Path screenshotsDir = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "kingdomkeys/save_points/");
        if (!this.savePoints.isEmpty() && Files.exists(screenshotsDir, new LinkOption[0]) && (fileArray = screenshotsDir.toFile().listFiles()) != null && fileArray.length > 0 && !(files = Arrays.stream(fileArray).collect(Collectors.toMap(file -> {
            String fileName = file.getName();
            int uuidIndex = fileName.lastIndexOf("_") + 1;
            String uuidString = fileName.substring(uuidIndex, fileName.length() - 4);
            return UUID.fromString(uuidString);
        }, file -> file, (file, file2) -> {
            File toDelete;
            String[] fileNameSplit = file.getName().split("_");
            UUID uuid = UUID.fromString(fileNameSplit[1].substring(0, fileNameSplit[1].length() - 4));
            String savePointName = ((SavePointStorage.SavePoint)this.savePoints.get(uuid).getFirst()).name();
            File file3 = toDelete = savePointName.equals(fileNameSplit[0]) ? file2 : file;
            if (toDelete.delete()) {
                KingdomKeys.LOGGER.info("Deleted old save point screenshot under previous name {}", (Object)toDelete.getName());
            }
            return !savePointName.equals(fileNameSplit[0]) ? file2 : file;
        }))).isEmpty()) {
            files.forEach((uuid, file) -> {
                if (this.savePoints.containsKey(uuid)) {
                    String nameNoInvalid = ((SavePointStorage.SavePoint)this.savePoints.get(uuid).getFirst()).name().replaceAll("[\\\\/:*?\"<>|]", "_").toLowerCase();
                    if (file.isFile() && file.getName().equals(nameNoInvalid + "_" + uuid.toString() + ".png")) {
                        fileMap.put((UUID)uuid, (File)file);
                    }
                }
            });
        }
        return fileMap;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.create) {
            this.nameField = new EditBoxLength(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 50, this.f_96544_ / 2 - 10 - 40, 100, 20, 32, (Component)Component.m_237119_()){

                @Override
                public boolean m_5534_(char pCodePoint, int pModifiers) {
                    boolean b = super.m_5534_(pCodePoint, pModifiers);
                    SavePointScreen.this.updateButtons();
                    return b;
                }

                @Override
                public void deleteChars(int pNum) {
                    super.deleteChars(pNum);
                    SavePointScreen.this.updateButtons();
                }
            };
            this.m_142416_(this.nameField);
            this.setGlobal = new CheckboxButton(this.f_96543_ / 2 - 60, this.f_96544_ / 2 - 14, "gui.save.create.global", false, "gui.save.create.global.desc", Color.WHITE.getRGB());
            this.m_142416_((GuiEventListener)this.setGlobal);
            this.save = new MenuButton(this.f_96543_ / 2 - 60, this.f_96544_ / 2, 100, Utils.translateToLocal("gui.save.create.accept", new Object[0]), MenuButton.ButtonType.BUTTON, press -> this.action(0));
            this.m_142416_((GuiEventListener)this.save);
        } else {
            this.init(0, 0);
        }
        this.updateButtons();
    }

    public Comparator<? super Map.Entry<UUID, Pair<SavePointStorage.SavePoint, Instant>>> getSortedList(int sorting) {
        return switch (sorting) {
            case 0 -> Comparator.comparing(uuidPairEntry -> (Instant)((Pair)uuidPairEntry.getValue()).getSecond()).reversed();
            case 1 -> Comparator.comparing(uuidPairEntry -> ((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).name().toLowerCase()).thenComparing(uuidPairEntry -> ((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).name());
            case 2 -> Comparator.comparing(uuidPairEntry -> ((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).dimension());
            case 3 -> Comparator.comparing(uuidPairEntry -> (String)((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).owner().getSecond());
            default -> Map.Entry.comparingByKey();
        };
    }

    public void init(int sorting, int ordering) {
        Objects.requireNonNull(this.f_96547_);
        int elementHeight = 9 * 5 + 4;
        int elementWidth = (int)((float)elementHeight * 1.7777778f);
        int maxRowWidth = (int)((float)this.f_96543_ / 1.5f);
        int elementsPerRow = (int)Math.max(1.0f, (float)maxRowWidth / (float)(elementWidth + 2));
        int column = 0;
        int row = 0;
        int yPos = 0;
        Comparator<? super Map.Entry<UUID, Pair<SavePointStorage.SavePoint, Instant>>> comparator = this.getSortedList(sorting);
        comparator = ordering == 0 ? comparator : comparator.reversed();
        List sortedList = this.savePoints.entrySet().stream().filter(uuidPairEntry -> !((UUID)uuidPairEntry.getKey()).equals(this.tileEntity.getID())).sorted(comparator).map(Map.Entry::getKey).collect(Collectors.toList());
        sortedList.add(0, this.tileEntity.getID());
        for (UUID uuid : sortedList) {
            SavePointStorage.SavePoint savePoint = (SavePointStorage.SavePoint)this.savePoints.get(uuid).getFirst();
            if ((this.type != SavePointStorage.SavePointType.WARP || savePoint.type() != SavePointStorage.SavePointType.WARP) && savePoint.dimension() != this.tileEntity.m_58904_().m_46472_()) continue;
            if (column == elementsPerRow) {
                column = 0;
                ++row;
            }
            yPos = (int)(this.topBarHeight + 2.0f + (float)((elementHeight + 2) * row));
            SavePointButton button = new SavePointButton(this, this.f_96543_ / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * column, yPos, elementWidth, elementHeight, (Component)Component.m_237113_((String)savePoint.name()), uuid);
            if (uuid.equals(this.tileEntity.getID())) {
                button.f_93623_ = false;
                int bwidth = elementWidth;
                int retakeOffset = 0;
                if (((UUID)this.current.owner().getFirst()).equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                    retakeOffset = (bwidth /= 2) + 1;
                    this.rename = new SavePointExtrasButton(this.f_96543_ / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * column, yPos, bwidth, (Component)Component.m_237115_((String)"gui.save.main.rename"), pButton -> this.action(1));
                    this.m_142416_((GuiEventListener)this.rename);
                }
                this.retake = new SavePointExtrasButton(this.f_96543_ / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * column + retakeOffset, yPos, bwidth, (Component)Component.m_237115_((String)"gui.save.main.retake"), pButton -> this.action(2));
                this.m_142416_((GuiEventListener)this.retake);
            }
            this.m_142416_((GuiEventListener)button);
            ++column;
        }
        int n = this.f_96543_ / 2 - (elementWidth + 2) * elementsPerRow / 2 - 62;
        int n2 = (int)this.topBarHeight;
        Objects.requireNonNull(this.f_96547_);
        this.sortDropDown = new DropDownButton(n, n2, 60, 9, List.of(Component.m_237115_((String)"gui.save.sort.recent"), Component.m_237115_((String)"gui.save.sort.name"), Component.m_237115_((String)"gui.save.sort.dimension"), Component.m_237115_((String)"gui.save.sort.owner")), (Component)Component.m_237115_((String)"gui.save.main.sort"));
        this.m_142416_((GuiEventListener)this.sortDropDown);
        int n3 = this.f_96543_ / 2 - (elementWidth + 2) * elementsPerRow / 2 - 72;
        int n4 = (int)this.topBarHeight;
        Objects.requireNonNull(this.f_96547_);
        int n5 = n4 + 9 + 4;
        Objects.requireNonNull(this.f_96547_);
        this.orderDropDown = new DropDownButton(n3, n5, 70, 9, List.of(Component.m_237115_((String)"gui.save.sort.ascending"), Component.m_237115_((String)"gui.save.sort.descending")), (Component)Component.m_237119_());
        this.m_142416_((GuiEventListener)this.orderDropDown);
        this.sortDropDown.setSelected(sorting);
        this.orderDropDown.setSelected(ordering);
        this.sorting = sorting;
        this.ordering = ordering;
        this.bar = new MenuScrollBar(this.f_96543_ / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * elementsPerRow, (int)this.topBarHeight, (int)(this.topBarHeight + this.middleHeight), (int)this.middleHeight, (int)((float)yPos - this.topBarHeight) + elementHeight + 2);
        this.m_142416_((GuiEventListener)this.bar);
    }

    public void updateScroll(MenuScrollBar bar) {
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof SavePointButton)) continue;
            SavePointButton button = (SavePointButton)renderable;
            button.offsetY = (int)bar.scrollOffset;
        }
        if (this.rename != null) {
            this.rename.offsetY = (int)bar.scrollOffset;
        }
        if (this.retake != null) {
            this.retake.offsetY = (int)bar.scrollOffset;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.bar != null) {
            this.bar.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (this.sortDropDown != null && this.orderDropDown != null) {
            if (this.sortDropDown.isOpen() && !this.orderDropDown.isOpen()) {
                return this.sortDropDown.m_6375_(pMouseX, pMouseY, pButton);
            }
            if (!this.sortDropDown.isOpen() && this.orderDropDown.isOpen()) {
                return this.orderDropDown.m_6375_(pMouseX, pMouseY, pButton);
            }
        }
        if ((pMouseY > (double)(this.topBarHeight + this.middleHeight) || pMouseY < (double)this.topBarHeight) && !this.create) {
            return false;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.bar != null) {
            this.bar.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
            this.updateScroll(this.bar);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (this.bar != null) {
            this.bar.m_6348_(pMouseX, pMouseY, pButton);
        }
        if (this.sortDropDown != null && this.orderDropDown != null) {
            this.orderDropDown.f_93623_ = !this.sortDropDown.isOpen();
            boolean bl = this.sortDropDown.f_93623_ = !this.orderDropDown.isOpen();
            if (this.sortDropDown.getSelected() != this.sorting || this.orderDropDown.getSelected() != this.ordering) {
                this.f_169369_.clear();
                this.m_6702_().clear();
                this.init(this.sortDropDown.getSelected(), this.orderDropDown.getSelected());
            }
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.bar != null) {
            this.bar.m_6050_(pMouseX, pMouseY, pDelta);
            this.updateScroll(this.bar);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public static class Screenshot
    implements AutoCloseable {
        private static final ResourceLocation MISSING_LOCATION = null;
        private final TextureManager textureManager;
        private final ResourceLocation textureLocation;
        @Nullable
        private DynamicTexture texture;
        private boolean closed;

        private Screenshot(TextureManager pTextureManager, ResourceLocation pTextureLocation) {
            this.textureManager = pTextureManager;
            this.textureLocation = pTextureLocation;
        }

        public void upload(NativeImage pImage) {
            if (pImage.m_84982_() % 16 == 0 && pImage.m_85084_() % 9 == 0) {
                try {
                    this.checkOpen();
                    if (this.texture == null) {
                        this.texture = new DynamicTexture(pImage);
                    } else {
                        this.texture.m_117988_(pImage);
                        this.texture.m_117985_();
                    }
                    this.textureManager.m_118495_(this.textureLocation, (AbstractTexture)this.texture);
                }
                catch (Throwable throwable) {
                    pImage.close();
                    this.clear();
                    throw throwable;
                }
            } else {
                pImage.close();
                throw new IllegalArgumentException("Icon must be " + ScreenshotManager.width + "x" + ScreenshotManager.height + ", but was " + pImage.m_84982_() + "x" + pImage.m_85084_());
            }
        }

        public void clear() {
            this.checkOpen();
            if (this.texture != null) {
                this.textureManager.m_118513_(this.textureLocation);
                this.texture.close();
                this.texture = null;
            }
        }

        public ResourceLocation textureLocation() {
            return this.texture != null ? this.textureLocation : MISSING_LOCATION;
        }

        @Override
        public void close() {
            this.clear();
            this.closed = true;
        }

        private void checkOpen() {
            if (this.closed) {
                throw new IllegalStateException("Icon already closed");
            }
        }
    }
}

