/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuButton
extends MenuButtonBase {
    private ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
    private int endWidth = 11;
    private int bLeftU = 0;
    private int bMiddleU = 12;
    private int bRightU = 14;
    private int bVPos = 0;
    private int bSelectedVPos = 20;
    private int sbLeftU = 22;
    private int sbMiddleU = 34;
    private int sbRightU = 36;
    private int sbVPos = 118;
    private int sbSelectedVPos = 138;
    private int rbLeftU = 22;
    private int rbMiddleU = 34;
    private int rbRightU = 36;
    private int rbVPos = 158;
    private int rbSelectedVPos = 178;
    private int middleWidth;
    private int offset;
    private String data;
    private String tip;
    ButtonType type;
    private boolean selected;
    private boolean centerText;

    public void setCenterText(boolean b) {
        this.centerText = b;
    }

    public MenuButton(int x, int y, int widthIn, String buttonText, ButtonType type, Button.OnPress onPress) {
        super(x, y, 22 + widthIn, 20, Utils.translateToLocal(buttonText, new Object[0]), onPress);
        this.middleWidth = widthIn;
        this.type = type;
    }

    public MenuButton(int x, int y, int widthIn, String buttonText, ButtonType type, boolean hasTooltip, Button.OnPress onPress) {
        this(x, y, widthIn, buttonText, type, onPress);
        if (hasTooltip) {
            this.tip = buttonText + ".desc";
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    @ParametersAreNonnullByDefault
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.f_93622_ = mouseX > this.m_252754_() + 1 && mouseY >= this.m_252907_() + 1 && mouseX < this.m_252754_() + this.f_93618_ - 1 && mouseY < this.m_252907_() + this.f_93619_ - 1;
        Font font = Minecraft.m_91087_().f_91062_;
        PoseStack matrixStack = gui.m_280168_();
        if (this.f_93624_) {
            matrixStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            int btnMargin = 8;
            int textX = this.m_252754_() + btnMargin;
            int activeColor = new Color(255, 255, 255).hashCode();
            int disabledColor = new Color(100, 100, 100).hashCode();
            boolean shouldOffset = this.f_93622_ && this.f_93623_ || !this.f_93623_ && this.selected;
            int drawColor = this.f_93623_ ? activeColor : disabledColor;
            int x = this.m_252754_();
            if (shouldOffset) {
                this.m_252865_(x + this.offset);
            }
            this.drawButton(gui, this.f_93622_ && this.f_93623_);
            int drawX = textX + (shouldOffset ? this.offset : 0);
            ClientUtils.drawScrollingString(gui, font, this.m_6035_(), drawX, drawX + this.m_5711_() - btnMargin * 2, this.m_252907_() + 6, drawColor, this.centerText);
            if (shouldOffset) {
                this.m_252865_(x);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85849_();
        }
    }

    private void drawButton(GuiGraphics gui, boolean hovered) {
        int leftU = 0;
        int middleU = 0;
        int rightU = 0;
        int vPos = 0;
        int selVPos = 0;
        switch (this.type) {
            case BUTTON: {
                leftU = this.bLeftU;
                middleU = this.bMiddleU;
                rightU = this.bRightU;
                vPos = this.bVPos;
                selVPos = this.bSelectedVPos;
                this.offset = 10;
                break;
            }
            case SUBBUTTON: {
                leftU = this.sbLeftU;
                middleU = this.sbMiddleU;
                rightU = this.sbRightU;
                vPos = this.sbVPos;
                selVPos = this.sbSelectedVPos;
                this.offset = 10;
                break;
            }
            case ROUNDBUTTON: {
                leftU = this.rbLeftU;
                middleU = this.rbMiddleU;
                rightU = this.rbRightU;
                vPos = this.rbVPos;
                selVPos = this.rbSelectedVPos;
                this.offset = 0;
            }
        }
        vPos = hovered || this.selected ? selVPos : vPos;
        gui.m_280218_(this.texture, this.m_252754_(), this.m_252907_(), leftU, vPos, this.endWidth, this.f_93619_);
        for (int i = 0; i < this.middleWidth; ++i) {
            gui.m_280218_(this.texture, this.m_252754_() + i + this.endWidth, this.m_252907_(), middleU, vPos, 1, this.f_93619_);
        }
        gui.m_280218_(this.texture, this.m_252754_() + this.endWidth + this.middleWidth, this.m_252907_(), rightU, vPos, this.endWidth, this.f_93619_);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.f_93622_ && this.f_93623_) {
            return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return false;
    }

    public boolean m_274382_() {
        return this.f_93622_;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void m_7435_(SoundManager soundHandlerIn) {
        soundHandlerIn.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }

    public void m_93674_(int pWidth) {
        super.m_93674_(pWidth);
        this.middleWidth = pWidth;
    }

    public static enum ButtonType {
        BUTTON,
        SUBBUTTON,
        ROUNDBUTTON;

    }
}

