/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class DriveGui
extends OverlayBase {
    ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/drivebar.png");
    public static final DriveGui INSTANCE = new DriveGui();
    int maxDrive = 1000;
    int maxLength = 100;
    int maxBars = 9;
    double guiLength = 47.0;
    double oneValue = this.guiLength / 100.0;
    double currDrive;
    double currForm;
    static final int R = 0;
    static final int G = 1;
    static final int B = 2;
    int[] colors = new int[]{255, 255, 255};
    static final float CONS = 0.005f;
    float decimalColor = 0.0f;
    float previousPartialTick = 0.0f;
    public static float maxDriveTicks = 0.0f;
    public static float prevMaxDriveTicks = 0.0f;

    private DriveGui() {
    }

    public int getCurrBar(double dp, int level) {
        int bar = (int)dp / 100;
        if (bar > level) {
            bar = level;
        }
        return bar;
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.render(gui, guiGraphics, partialTick, width, height);
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
        if (playerData != null) {
            int numPos;
            double dp = playerData.getDP();
            double fp = playerData.getFP();
            this.currDrive = (float)(this.oneValue * dp - (double)this.getCurrBar(dp, (int)playerData.getMaxDP() / 100) * this.guiLength);
            if (playerData.getDriveFormMap() != null && playerData.getActiveDriveForm() != null && !playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                this.currForm = playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") ? (double)((float)(this.oneValue * fp - (double)this.getCurrBar(fp, 1000) * this.guiLength)) : (double)((float)(this.oneValue * fp - (double)this.getCurrBar(fp, 300 + playerData.getDriveFormMap().get(playerData.getActiveDriveForm())[0] * 100) * this.guiLength));
            }
            if (dp == playerData.getMaxDP()) {
                this.currDrive = this.guiLength;
            }
            int guiWidth = 95;
            int guiBarWidth = 83;
            int guiHeight = 18;
            int screenWidth = this.minecraft.m_91268_().m_85445_();
            int screenHeight = this.minecraft.m_91268_().m_85446_();
            float rawScale = 0.85f;
            float scaleX = rawScale * (float)ModConfigs.dpXScale / 100.0f;
            float scaleY = rawScale * (float)ModConfigs.dpYScale / 100.0f;
            float posX = 52.0f * scaleX;
            float posY = 20.0f * scaleY + 2.0f;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            poseStack.m_252880_((float)(-27 + ModConfigs.dpXPos), (float)(-2 + ModConfigs.dpYPos), 1.0f);
            poseStack.m_85836_();
            poseStack.m_252880_((float)screenWidth - (float)guiWidth * scaleX - posX, (float)screenHeight - (float)guiHeight * scaleY - posY, 0.0f);
            poseStack.m_85841_(scaleX, scaleY, 1.0f);
            if (playerData.getAlignment() == Utils.OrgMember.NONE) {
                if (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    this.blit(guiGraphics, this.texture, 15, 6, 0, 0, guiWidth, guiHeight);
                } else {
                    this.blit(guiGraphics, this.texture, 15, 6, 98, 0, guiWidth, guiHeight);
                }
            } else {
                this.blit(guiGraphics, this.texture, 15, 6, 0, 68, guiWidth, guiHeight);
            }
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)screenWidth - (float)guiWidth * scaleX + (float)(guiWidth - guiBarWidth) * scaleX + 24.0f * scaleX - posX, (float)screenHeight - (float)guiHeight * scaleY - 2.0f * scaleY - posY, 0.0f);
            poseStack.m_85841_(scaleX, scaleY, 1.0f);
            if (playerData.getAlignment() == Utils.OrgMember.NONE) {
                if (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    this.blit(guiGraphics, this.texture, 14, 6, 0, 18, (int)this.currDrive, guiHeight);
                } else {
                    this.blit(guiGraphics, this.texture, 14, 6, 98, 18, (int)this.currForm, guiHeight);
                }
            } else {
                this.blit(guiGraphics, this.texture, 14, 6, 0, 86, (int)this.currDrive, guiHeight);
            }
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)screenWidth - (float)guiWidth * scaleX + 85.0f * scaleX - posX, (float)screenHeight - (float)guiHeight * scaleY - 2.0f * scaleY - posY, 0.0f);
            poseStack.m_85841_(scaleX, scaleY, 1.0f);
            int n = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? this.getCurrBar(dp == 1000.0 ? 900.0 : dp, (int)playerData.getMaxDP() / 100) * 10 : (numPos = 100 + this.getCurrBar(fp, Utils.getDriveFormLevel(playerData.getDriveFormMap(), playerData.getActiveDriveForm()) + 2) * 10);
            if (playerData.getAlignment() == Utils.OrgMember.NONE) {
                this.blit(guiGraphics, this.texture, 14, 6, numPos, 38, 10, guiHeight);
            } else {
                this.blit(guiGraphics, this.texture, 14, 6, numPos, 106, 10, guiHeight);
            }
            poseStack.m_85849_();
            if (playerData.getDP() >= playerData.getMaxDP() && playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                poseStack.m_85836_();
                this.decimalColor = prevMaxDriveTicks + (maxDriveTicks - prevMaxDriveTicks) * partialTick;
                Color c = Color.getHSBColor(this.decimalColor, 1.0f, 1.0f);
                RenderSystem.setShaderColor((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
                poseStack.m_252880_((float)screenWidth - (float)guiWidth * scaleX + 10.0f * scaleX, (float)screenHeight - (float)guiHeight * scaleY - 10.0f * scaleY, 0.0f);
                poseStack.m_85841_(scaleX, scaleY, 1.0f);
                this.blit(guiGraphics, this.texture, 0, -3, 0, 57, 30, guiHeight);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public void ClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (maxDriveTicks >= 1.0f) {
            maxDriveTicks = 0.0f;
        }
        prevMaxDriveTicks = maxDriveTicks;
        maxDriveTicks = (float)((double)maxDriveTicks + 0.02);
    }
}

