/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LockOnGui
extends OverlayBase {
    public static final LockOnGui INSTANCE = new LockOnGui();
    int guiWidth = 256;
    int guiHeight = 256;
    int hpGuiWidth = 173;
    float hpBarWidth;
    float missingHpBarWidth;
    float hpPerBar;
    int hpBars;
    int currentBar;
    int oldBar;
    int hpGuiHeight = 10;
    int noborderguiwidth = 171;
    float lockOnScale;
    float hpBarScale;
    LivingEntity lastTrackedTarget;
    private float targetHealth;
    private long lastSystemTime;
    private float lastTargetHealth;
    final ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/hpbar.png");

    private LockOnGui() {
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (InputHandler.lockOn != null && event.getOverlay().equals((Object)VanillaGuiOverlay.CROSSHAIR.type())) {
            event.setCanceled(true);
        }
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.render(gui, guiGraphics, partialTick, width, height);
        LocalPlayer player = this.minecraft.f_91074_;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        if (playerData != null) {
            LivingEntity target = InputHandler.lockOn;
            if (target == null) {
                this.missingHpBarWidth = 0.0f;
                return;
            }
            if (player.m_20270_((Entity)target) > (float)InputHandler.LOCK_ON_REACH || player.m_21023_((MobEffect)ModMobEffects.KO.get())) {
                InputHandler.lockOn = null;
                return;
            }
            float size = 6.0f;
            int screenWidth = this.minecraft.m_91268_().m_85445_();
            int screenHeight = this.minecraft.m_91268_().m_85446_();
            this.lockOnScale = (float)ModConfigs.lockOnIconScale / 100.0f;
            this.hpBarScale = (float)ModConfigs.lockOnHPScale / 100.0f;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(screenWidth / 2) - (float)(this.guiWidth / 2) * this.lockOnScale / size - 0.5f, (float)(screenHeight / 2) - (float)(this.guiHeight / 2) * this.lockOnScale / size - 0.5f, 0.0f);
            poseStack.m_85841_(this.lockOnScale / size, this.lockOnScale / size, this.lockOnScale / size);
            this.blit(guiGraphics, new ResourceLocation("kingdomkeys", "textures/gui/lockon_0.png"), 0, 0, 0, 0, this.guiWidth, this.guiHeight);
            poseStack.m_252880_((float)(this.guiWidth / 2), (float)(this.guiWidth / 2), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)Math.toDegrees((float)(player.f_19797_ % 360 * ModConfigs.lockOnIconRotation) / 100.0f)));
            poseStack.m_252880_((float)(-this.guiWidth / 2), (float)(-this.guiWidth / 2), 0.0f);
            this.blit(guiGraphics, new ResourceLocation("kingdomkeys", "textures/gui/lockon_1.png"), 0, 0, 0, 0, this.guiWidth, this.guiHeight);
            poseStack.m_85849_();
            poseStack.m_85836_();
            if (target != null && playerData.isAbilityEquipped("kingdomkeys:ability_scan")) {
                IGlobalCapabilities targetData;
                poseStack.m_85836_();
                RenderSystem.enableBlend();
                poseStack.m_252880_((float)ModConfigs.lockOnXPos, (float)ModConfigs.lockOnYPos, 0.0f);
                Component targetName = target.m_7755_();
                if (!ModConfigs.mobLevelName && (targetData = ModCapabilities.getCachedGlobal(target)) != null && targetData.getLevel() > 0) {
                    targetName = Component.m_237115_((String)(target.m_5446_().getString() + " Lv." + String.valueOf(Utils.getLevelColor((Player)player, targetData.getLevel())) + targetData.getLevel() + String.valueOf(ChatFormatting.RESET)));
                }
                this.drawString(guiGraphics, this.minecraft.f_91062_, targetName, screenWidth - this.minecraft.f_91062_.m_92852_((FormattedText)targetName), (int)(26.0f * this.hpBarScale), 0xFFFFFF);
                this.drawHPBar(guiGraphics, target);
                RenderSystem.disableBlend();
                poseStack.m_85849_();
            }
            poseStack.m_85841_(this.hpBarScale, this.hpBarScale, this.hpBarScale);
            poseStack.m_85849_();
        }
    }

    public void drawHPBar(GuiGraphics gui, LivingEntity target) {
        float hpBarMaxWidth;
        int screenWidth = this.minecraft.m_91268_().m_85445_();
        this.hpPerBar = ModConfigs.lockOnHpPerBar;
        float widthMultiplier = 10.0f * this.hpBarScale;
        float targetHealth = Math.min(target.m_21223_(), target.m_21233_());
        this.hpBars = target.m_21233_() % this.hpPerBar == 0.0f ? (int)(target.m_21233_() / this.hpPerBar) : (int)(target.m_21233_() / this.hpPerBar) + 1;
        this.currentBar = targetHealth % this.hpPerBar == 0.0f ? (int)(targetHealth / this.hpPerBar) : (int)(targetHealth / this.hpPerBar) + 1;
        float firstBar = target.m_21233_() > this.hpPerBar ? target.m_21233_() % this.hpPerBar : target.m_21233_();
        float oneBar = target.m_21233_() > this.hpPerBar ? this.hpPerBar : target.m_21233_();
        this.hpBarWidth = targetHealth % this.hpPerBar == 0.0f && targetHealth != 0.0f ? oneBar * widthMultiplier : targetHealth % this.hpPerBar * widthMultiplier;
        float i = targetHealth;
        long j = Util.m_137550_();
        if (i < this.targetHealth && target.f_19802_ > 0) {
            this.lastSystemTime = j;
        } else if (i > this.targetHealth && target.f_19802_ > 0) {
            this.lastSystemTime = j;
        }
        if (j - this.lastSystemTime > 1000L || this.targetHealth < targetHealth) {
            this.targetHealth = i;
            this.lastTargetHealth = i;
            this.lastSystemTime = j;
            this.oldBar = this.currentBar;
            this.missingHpBarWidth = 0.0f;
        }
        this.missingHpBarWidth = targetHealth % this.hpPerBar == 0.0f ? 0.0f : Math.min(Math.max(this.lastTargetHealth - targetHealth, 0.0f), this.hpPerBar - targetHealth % this.hpPerBar) % this.hpPerBar * widthMultiplier;
        float bgHPBarMaxWidth = 0.0f;
        if (target.m_21233_() >= this.hpPerBar) {
            if (targetHealth + this.hpPerBar > target.m_21233_() && this.currentBar == this.hpBars) {
                hpBarMaxWidth = firstBar * widthMultiplier;
                bgHPBarMaxWidth = this.hpPerBar * widthMultiplier;
            } else if (this.currentBar == 1) {
                hpBarMaxWidth = oneBar * widthMultiplier;
                bgHPBarMaxWidth = 0.0f;
            } else {
                hpBarMaxWidth = oneBar * widthMultiplier;
                bgHPBarMaxWidth = this.hpPerBar * widthMultiplier;
            }
        } else {
            hpBarMaxWidth = target.m_21233_() % this.hpPerBar * widthMultiplier;
        }
        gui.m_280168_().m_85836_();
        this.drawHPBarBack(gui, (float)screenWidth - hpBarMaxWidth - 4.0f * this.hpBarScale, 0.0f * this.hpBarScale, hpBarMaxWidth, this.hpBarScale, (float)screenWidth - bgHPBarMaxWidth - 4.0f * this.hpBarScale, bgHPBarMaxWidth);
        this.drawHPBarTop(gui, (float)screenWidth - this.hpBarWidth - 2.0f * this.hpBarScale, 2.0f * this.hpBarScale, this.hpBarWidth, this.hpBarScale);
        this.drawDamagedHPBarTop(gui, (float)screenWidth - this.hpBarWidth - this.missingHpBarWidth - 2.0f * this.hpBarScale, 2.0f * this.hpBarScale, this.missingHpBarWidth, this.hpBarScale, target);
        this.drawHPBars(gui, (float)screenWidth - hpBarMaxWidth - 4.0f * this.hpBarScale, 0.0f * this.hpBarScale, hpBarMaxWidth, this.hpBarScale, target);
        this.drawDamagedHPBars(gui, (float)screenWidth - hpBarMaxWidth - 4.0f * this.hpBarScale, 0.0f * this.hpBarScale, hpBarMaxWidth, this.hpBarScale, target);
        gui.m_280168_().m_85849_();
    }

    public void drawHPBarBack(GuiGraphics gui, float posX, float posY, float width, float scale, float bgPosX, float bgHPBarMaxWidth) {
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(posX, posY, 0.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(bgPosX - posX, posY, 0.0f);
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 0, 0, 2, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f * scale, 0.0f, 0.0f);
        matrixStack.m_85841_(bgHPBarMaxWidth, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 14, 0, 1, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f * scale + bgHPBarMaxWidth, 0.0f, 0.0f);
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 3, 0, 2, 12);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 0, 0, 2, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f * scale, 0.0f, 0.0f);
        matrixStack.m_85841_(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 2, 0, 1, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f * scale + width, 0.0f, 0.0f);
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 3, 0, 2, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(width - 20.0f * scale, 12.0f * scale, 0.0f);
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 1, 0, 0, 32, 23, 12);
        matrixStack.m_85849_();
        for (int i = 0; i < this.hpBars - 1; ++i) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(width - 19.0f * scale - 17.0f * scale * (float)(i + 1), 12.0f * scale, 0.0f);
            matrixStack.m_85841_(scale, scale, 0.0f);
            this.blit(gui, this.texture, 0, 0, 0, 46, 17, 12);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public void drawHPBarTop(GuiGraphics gui, float posX, float posY, float width, float scale) {
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(posX, posY, 0.0f);
        matrixStack.m_85841_(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 2, 12, 1, 8);
        matrixStack.m_85849_();
    }

    private void drawHPBars(GuiGraphics gui, float posX, float posY, float width, float scale, LivingEntity target) {
        PoseStack matrixStack = gui.m_280168_();
        if (target.m_6084_()) {
            for (int i = 1; i < this.currentBar; ++i) {
                matrixStack.m_85836_();
                matrixStack.m_252880_(posX + width - 17.0f * scale - 17.0f * scale * (float)i - 2.0f * scale, posY + 12.0f * scale, 0.0f);
                matrixStack.m_85841_(scale, scale, 0.0f);
                this.blit(gui, this.texture, 0, 0, 0, 60, 17, 12);
                matrixStack.m_85849_();
            }
        }
    }

    private void drawDamagedHPBarTop(GuiGraphics gui, float posX, float posY, float width, float scale, LivingEntity target) {
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(posX, posY, 0.0f);
        matrixStack.m_85841_(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 2, 22, 1, 8);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    private void drawDamagedHPBars(GuiGraphics gui, float posX, float posY, float width, float scale, LivingEntity target) {
        PoseStack matrixStack = gui.m_280168_();
        if (target.m_6084_()) {
            for (int i = this.currentBar; i < this.oldBar; ++i) {
                matrixStack.m_85836_();
                matrixStack.m_252880_(posX + width - 17.0f * scale - 17.0f * scale * (float)i - 2.0f * scale, posY + 12.0f * scale, 0.0f);
                matrixStack.m_85841_(scale, scale, 0.0f);
                this.blit(gui, this.texture, 0, 0, 17, 60, 17, 12);
                matrixStack.m_85849_();
            }
        }
    }
}

