/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class DimensionCommand
extends BaseCommand {
    public static SuggestionProvider<CommandSourceStack> SUGGEST_DIMENSIONS = (p_198296_0_, p_198296_1_) -> {
        List<String> list = ServerLifecycleHooks.getCurrentServer().m_129784_().stream().map(rk -> rk.m_135782_().toString()).toList();
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").requires(source -> source.m_6761_(2));
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dim", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DIMENSIONS).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(DimensionCommand::changeDim))).executes(DimensionCommand::changeDim));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int changeDim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = DimensionCommand.getPlayers(context, 3);
        String dim = StringArgumentType.getString(context, (String)"dim");
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim));
        for (ServerPlayer player : players) {
            if (player.m_20194_().m_129880_(dimension) == null) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Invalid dimension " + dim)), true);
                return 1;
            }
            BlockPos coords = DimensionCommand.getWorldCoords((Player)player, (ResourceKey<Level>)dimension);
            player.changeDimension(player.m_20194_().m_129880_(dimension), (ITeleporter)new BaseTeleporter(coords));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Teleported " + player.m_5446_().getString() + " to dimension " + dimension.m_135782_().toString())), true);
            player.m_213846_((Component)Component.m_237115_((String)("You have been teleported to " + dimension.m_135782_().toString())));
        }
        return 1;
    }

    public static BlockPos getWorldCoords(Player player, ResourceKey<Level> dimension) {
        if (dimension.m_135782_().toString().contains("castle_oblivion_interior_")) {
            player.m_213846_((Component)Component.m_237115_((String)"I REPEAT, CASTLE OBLIVION IS WORK IN PROGRESS DON'T REPORT ANY ISSUES WITH IT YET PLEASE"));
            player.m_213846_((Component)Component.m_237115_((String)"IF YOUR GAME CRASHES HERE IT'S EXPECTED, THE OUTSIDE PART IS PROBABLY SAFE FROM CRASHES BUT NOT HERE DEFINITELY NOT HERE"));
            player.m_213846_((Component)Component.m_237115_((String)"THANK YOU AGAIN - Estelle"));
            return new BlockPos(8, 62, 8);
        }
        if (dimension == ModDimensions.DIVE_TO_THE_HEART) {
            return new BlockPos(0, 26, 0);
        }
        if (dimension == ModDimensions.STATION_OF_SORROW) {
            return new BlockPos(0, 26, 0);
        }
        if (dimension == ModDimensions.CASTLE_OBLIVION) {
            player.m_213846_((Component)Component.m_237115_((String)"CASTLE OBLIVION IS WORK IN PROGRESS DON'T REPORT ANY ISSUES WITH IT YET PLEASE"));
            player.m_213846_((Component)Component.m_237115_((String)"IN CASE IT WASN'T OBVIOUS BY THE NEED TO USE THIS COMMAND TO GET HERE"));
            player.m_213846_((Component)Component.m_237115_((String)"THANK YOU - Estelle"));
            if (!FMLEnvironment.production) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.plainsCard.get()));
                player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.netherCard.get()));
                ItemStack nineCard = new ItemStack((ItemLike)ModItems.tranquilDarkness.get());
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("value", 9);
                nineCard.m_41751_(tag);
                nineCard.m_41764_(64);
                player.m_150109_().m_36054_(nineCard);
                return new BlockPos(-6, 90, 8);
            }
            return new BlockPos(-2, 90, -167);
        }
        if (dimension.m_135782_().toString().contains("realm_of_darkness")) {
            return player.m_20194_().m_129880_(dimension).m_220360_();
        }
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (dimension == playerData.getReturnDimension()) {
            Vec3 vec3 = playerData.getReturnLocation();
            return new BlockPos((int)vec3.f_82479_, (int)vec3.f_82480_, (int)vec3.f_82481_);
        }
        return new BlockPos(0, 64, 0);
    }
}

