/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MaterialCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_MATERIALS = (context, builder) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry itemEntry : ForgeRegistries.ITEMS.getEntries()) {
            if (!new ItemStack((ItemLike)itemEntry.getValue()).m_204117_(Tags.MATERIALS)) continue;
            list.add(((ResourceKey)itemEntry.getKey()).m_135782_().toString());
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"material").requires(source -> source.m_6761_(2));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MaterialCommand::addMaterial))).executes(MaterialCommand::addMaterial)))).then(Commands.m_82127_((String)"all").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MaterialCommand::addAllMaterials))).executes(MaterialCommand::addAllMaterials))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"take").then(Commands.m_82129_((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MaterialCommand::takeMaterial))).executes(MaterialCommand::takeMaterial)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MaterialCommand::takeAllMaterials))).executes(MaterialCommand::takeAllMaterials)));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MaterialCommand::setMaterial))).executes(MaterialCommand::setMaterial)))).then(Commands.m_82127_((String)"all").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MaterialCommand::setAllMaterials))).executes(MaterialCommand::setAllMaterials))));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addMaterial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        ResourceLocation materialName = new ResourceLocation((String)context.getArgument("material", String.class));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Item material = (Item)ForgeRegistries.ITEMS.getValue(materialName);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.addMaterial(material, amount);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Given x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' to " + player.m_5446_().getString())), true);
            player.m_213846_((Component)Component.m_237115_((String)("You have been given x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "'")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int takeMaterial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        ResourceLocation materialName = new ResourceLocation((String)context.getArgument("material", String.class));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Item material = (Item)ForgeRegistries.ITEMS.getValue(materialName);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.removeMaterial(material, amount);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed material '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' from " + player.m_5446_().getString())), true);
            player.m_213846_((Component)Component.m_237115_((String)("x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' have been taken away from you")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int addAllMaterials(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            for (Item material : Tags.getItemsInTag(player.m_9236_(), Tags.MATERIALS)) {
                playerData.addMaterial(material, amount);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Given all materials to " + player.m_5446_().getString())), true);
            player.m_213846_((Component)Component.m_237115_((String)"You have been given all the materials"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int takeAllMaterials(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.clearMaterials();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Taken all materials from " + player.m_5446_().getString())), true);
            player.m_213846_((Component)Component.m_237115_((String)"Your materials have been taken away"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int setMaterial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        ResourceLocation materialName = new ResourceLocation((String)context.getArgument("material", String.class));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Item material = (Item)ForgeRegistries.ITEMS.getValue(materialName);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.setMaterial(material, amount);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' to " + player.m_5446_().getString())), true);
            player.m_213846_((Component)Component.m_237115_((String)("Your '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' have been set to x" + amount)));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int setAllMaterials(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            for (Item material : Tags.getItemsInTag(player.m_9236_(), Tags.MATERIALS)) {
                playerData.setMaterial(material, amount);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set all materials for " + player.m_5446_().getString() + " to " + amount)), true);
            player.m_213846_((Component)Component.m_237115_((String)("You have been set all the materials to " + amount)));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

