/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.datagen.init.KeybladeStats;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeLevel;

public class KeybladeBuilder
extends ModelFile {
    private ResourceLocation keychain;
    private int baseStr;
    private int baseMag;
    private String desc;
    private String baseAbility;
    private float reach;
    private ArrayList<KeybladeLevel> keybladeLevels = new ArrayList();

    public KeybladeBuilder(Object o, Object o1) {
        super((ResourceLocation)o);
    }

    private KeybladeBuilder self() {
        return this;
    }

    public KeybladeBuilder keychain(String keyChain) {
        Preconditions.checkNotNull((Object)keyChain, (Object)"Texture must not be null");
        ResourceLocation asLoc = keyChain.contains(":") ? new ResourceLocation(keyChain) : new ResourceLocation(this.getLocation().m_135827_(), keyChain);
        return this.keychain(asLoc);
    }

    public KeybladeBuilder keychain(ResourceLocation keychain) {
        Preconditions.checkNotNull((Object)keychain, (Object)"Keychain must not be null");
        this.keychain = keychain;
        return this.self();
    }

    public KeybladeBuilder baseStats(int baseStr, int baseMag) {
        this.baseMag = baseMag;
        this.baseStr = baseStr;
        return this.self();
    }

    public KeybladeBuilder level(KeybladeLevel keybladeLevel) {
        this.keybladeLevels.add(keybladeLevel);
        return this.self();
    }

    public KeybladeBuilder levels(KeybladeStats.Recipe[] recipes) {
        int baseMag = this.baseMag;
        int baseStr = this.baseStr;
        for (int i = 0; i < recipes.length; ++i) {
            if (i % 2 == 0) {
                ++baseMag;
            } else {
                ++baseStr;
            }
            this.keybladeLevels.add(new KeybladeLevel.KeybladeLevelBuilder().withStats(baseStr, baseMag).withMaterials(recipes[i]).build());
        }
        return this.self();
    }

    public KeybladeBuilder desc(String desc) {
        this.desc = desc;
        return this.self();
    }

    public KeybladeBuilder ability(String ability) {
        this.baseAbility = ability;
        return this.self();
    }

    public KeybladeBuilder reach(float reach) {
        this.reach = reach;
        return this.self();
    }

    protected boolean exists() {
        return true;
    }

    @VisibleForTesting
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonObject baseStat = new JsonObject();
        JsonArray levels = new JsonArray();
        root.addProperty("ability", this.baseAbility);
        root.addProperty("reach", (Number)Float.valueOf(this.reach));
        if (this.keychain != null) {
            root.addProperty("keychain", this.keychain.toString());
        }
        baseStat.addProperty("str", (Number)this.baseStr);
        baseStat.addProperty("mag", (Number)this.baseMag);
        root.add("base_stats", (JsonElement)baseStat);
        for (KeybladeLevel k : this.keybladeLevels) {
            JsonObject obj1 = new JsonObject();
            levels.add((JsonElement)obj1);
            obj1.addProperty("str", (Number)k.getStrength());
            obj1.addProperty("mag", (Number)k.getMagic());
            JsonArray recipe = new JsonArray();
            if (k.getMaterialList() != null) {
                k.getMaterialList().forEach((key, value) -> {
                    JsonObject matObj = new JsonObject();
                    matObj.addProperty("material", ForgeRegistries.ITEMS.getKey(key).toString());
                    matObj.addProperty("quantity", (Number)value);
                    recipe.add((JsonElement)matObj);
                });
            }
            obj1.add("recipe", (JsonElement)recipe);
            if (k.getAbility() == null) continue;
            obj1.addProperty("ability", k.getAbility());
        }
        root.add("levels", (JsonElement)levels);
        root.addProperty("description", this.desc);
        return root;
    }
}

