/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SynthesisRecipeBuilder
extends ModelFile {
    private ResourceLocation output;
    private String type;
    private Map<String, Integer> recipe = new HashMap<String, Integer>();
    private int quantity;
    private int cost;
    private int tier;

    public SynthesisRecipeBuilder(Object o, Object o1) {
        super((ResourceLocation)o);
    }

    private SynthesisRecipeBuilder self() {
        return this;
    }

    public SynthesisRecipeBuilder output(String output, int quantity) {
        Preconditions.checkNotNull((Object)output, (Object)"Texture must not be null");
        ResourceLocation asLoc = output.contains(":") ? new ResourceLocation(output) : new ResourceLocation(this.getLocation().m_135827_(), output);
        return this.output(asLoc, quantity);
    }

    public SynthesisRecipeBuilder output(ResourceLocation output, int quantity) {
        Preconditions.checkNotNull((Object)output, (Object)"Keychain must not be null");
        this.output = output;
        this.quantity = quantity;
        return this.self();
    }

    public SynthesisRecipeBuilder addType(String type) {
        this.type = type;
        return this.self();
    }

    public SynthesisRecipeBuilder addCost(int cost) {
        this.cost = cost;
        return this.self();
    }

    public SynthesisRecipeBuilder addTier(int tier) {
        this.tier = tier;
        return this.self();
    }

    public SynthesisRecipeBuilder addMaterial(RegistryObject<Item> mat, int quantity) {
        return this.addMaterial((Item)mat.get(), quantity);
    }

    public SynthesisRecipeBuilder addMaterial(Item mat, int quantity) {
        this.recipe.put(ForgeRegistries.ITEMS.getKey((Object)mat).toString(), quantity);
        return this.self();
    }

    protected boolean exists() {
        return true;
    }

    @VisibleForTesting
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonObject obj1 = new JsonObject();
        JsonArray recipes = new JsonArray();
        root.addProperty("cost", (Number)this.cost);
        root.addProperty("tier", (Number)this.tier);
        if (this.output != null) {
            obj1.addProperty("item", this.output.toString());
            obj1.addProperty("quantity", (Number)this.quantity);
            obj1.addProperty("type", this.type);
        }
        if (this.recipe != null) {
            this.recipe.forEach((key, value) -> {
                JsonObject matObj = new JsonObject();
                matObj.addProperty("material", key.toString());
                matObj.addProperty("quantity", value.toString());
                recipes.add((JsonElement)matObj);
            });
        }
        root.add("output", (JsonElement)obj1);
        root.add("ingredients", (JsonElement)recipes);
        return root;
    }
}

