/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.init;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import online.kingdomkeys.kingdomkeys.block.DataPortalBlock;
import online.kingdomkeys.kingdomkeys.block.GhostBloxBlock;
import online.kingdomkeys.kingdomkeys.block.MagicalChestBlock;
import online.kingdomkeys.kingdomkeys.block.MagnetBloxBlock;
import online.kingdomkeys.kingdomkeys.block.OrgPortalBlock;
import online.kingdomkeys.kingdomkeys.block.PairBloxBlock;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.block.SoAPlatformCoreBlock;
import online.kingdomkeys.kingdomkeys.block.SoRCore;
import online.kingdomkeys.kingdomkeys.item.BaseArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKRecordItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.RecipeItem;
import online.kingdomkeys.kingdomkeys.item.SynthesisItem;

public class ItemModels
extends ItemModelProvider {
    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "kingdomkeys", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject itemRegistryObject : ModItems.ITEMS.getEntries()) {
            Item item = (Item)itemRegistryObject.get();
            String path = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
            if (item instanceof BaseArmorItem) {
                this.standardArmor(path);
                continue;
            }
            if (item instanceof KeychainItem) {
                this.standardKeychain(path);
                continue;
            }
            if (item instanceof SynthesisItem) {
                this.standardMaterial(path);
                continue;
            }
            if (item instanceof BlockItem) {
                this.blockLogic((BlockItem)item, path);
                continue;
            }
            if (item instanceof KKRecordItem) {
                this.standardDisc(path);
                continue;
            }
            if (item instanceof KKArmorItem) {
                this.standardKKArmor(path);
                continue;
            }
            if (item instanceof KKAccessoryItem) {
                this.standardKKAccessory(path);
                continue;
            }
            if (item instanceof KeybladeItem || item instanceof ShieldItem || item instanceof SwordItem) continue;
            if (item instanceof SpawnEggItem) {
                this.standardSpawnEggItem(path);
                continue;
            }
            if (item instanceof RecipeItem && !path.equals("recipe")) {
                this.standardRecipe(path);
                continue;
            }
            this.standardItem(path);
        }
    }

    private void blockLogic(BlockItem item, String path) {
        Block block = item.m_40614_();
        if (!(block instanceof GhostBloxBlock) && !(block instanceof PairBloxBlock)) {
            if (block instanceof MagnetBloxBlock) {
                this.standardBlockItem("magnet_blox_on");
                this.standardBlockItem("magnet_blox_off");
            } else if (!(block instanceof OrgPortalBlock || block instanceof SavePointBlock || block instanceof SoRCore || block instanceof SoAPlatformCoreBlock || block instanceof DataPortalBlock)) {
                if (block instanceof MagicalChestBlock) {
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile("kingdomkeys:block/" + path))).transforms().transform(ItemDisplayContext.GUI).rotation(0.0f, 0.0f, 0.0f).translation(-0.25f, 1.0f, 0.0f).scale(1.0f, 1.0f, 1.0f).end();
                } else {
                    this.standardBlockItem(path);
                }
            }
        }
    }

    void standardMaterial(String name) {
        this.standardItem(name, "synthesis/");
    }

    void standardDisc(String name) {
        this.standardItem(name, "discs/");
    }

    void standardArmor(String name) {
        this.standardItem(name, "armor/");
    }

    void standardKeychain(String name) {
        this.standardItem(name, "keychains/");
    }

    void standardKKArmor(String name) {
        this.standardItem(name, "kkarmors/");
    }

    void standardKKAccessory(String name) {
        this.standardItem(name, "kkaccessories/");
    }

    void standardRecipe(String name) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/" + name + "_tier");
    }

    void standardBlockItem(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("kingdomkeys:block/" + name));
    }

    void standardItem(String name) {
        this.standardItem(name, "");
    }

    void standardItem(String name, String path) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/" + path + name);
    }

    void standardSpawnEggItem(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }

    public String m_6055_() {
        return "Item Models";
    }
}

