/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveFormData;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;

public abstract class DriveForm {
    public static final ResourceLocation NONE = new ResourceLocation("kingdomkeys:none");
    public static final ResourceLocation SYNCH_BLADE = new ResourceLocation("kingdomkeys:synch_blade");
    public static final float[] VALOR_JUMP_BOOST = new float[]{0.0f, 0.02f, 0.02f, 0.03f, 0.03f, 0.04f, 0.04f, 0.06f};
    public static final float[] MASTER_AERIAL_DODGE_BOOST = new float[]{0.0f, 1.0f, 1.0f, 1.2f, 1.2f, 1.4f, 1.4f, 1.6f};
    public static final float[] FINAL_JUMP_BOOST = new float[]{0.0f, 0.02f, 0.02f, 0.025f, 0.025f, 0.03f, 0.03f, 0.055f};
    public static final float[] FINAL_GLIDE = new float[]{0.0f, -0.09f, -0.09f, -0.06f, -0.06f, -0.03f, -0.03f, -0.01f};
    public static final float[] FINAL_GLIDE_SPEED = new float[]{0.0f, 1.8f, 1.8f, 2.8f, 2.8f, 3.6f, 3.6f, 5.0f};
    ResourceLocation name;
    int maxLevel;
    int order;
    public float[] color;
    public ResourceLocation skinRL;
    boolean baseGrowth;
    String translationKey;
    boolean hasKeychain = false;
    private DriveFormData data = new DriveFormData();

    public DriveForm(ResourceLocation registryName, int order, boolean hasKeychain, boolean baseGrowth) {
        this.name = registryName;
        this.maxLevel = 7;
        this.order = order;
        this.hasKeychain = hasKeychain;
        this.translationKey = "form." + registryName.m_135815_() + ".name";
        this.baseGrowth = baseGrowth;
    }

    public DriveForm(String registryName, int order, boolean hasKeychain, boolean baseGrowth) {
        this(new ResourceLocation(registryName), order, hasKeychain, baseGrowth);
    }

    public void setDriveFormData(DriveFormData data) {
        this.data = data;
    }

    public DriveFormData getDriveFormData() {
        return this.data;
    }

    public boolean hasKeychain() {
        return this.hasKeychain;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getDriveCost() {
        return this.data.getCost();
    }

    public int getFormAntiPoints() {
        return this.data.getAP();
    }

    public int[] getLevelUpCosts() {
        if (this.data != null) {
            return this.data.getLevelUp();
        }
        return new int[0];
    }

    public int getOrder() {
        return this.order;
    }

    public float[] getDriveColor() {
        return this.color;
    }

    public ResourceLocation getTextureLocation(Player player) {
        return this.skinRL;
    }

    public String getBaseAbilityForLevel(int driveFormLevel) {
        if (driveFormLevel < 1) {
            return "";
        }
        return this.data.getBaseAbilityForLevel(driveFormLevel - 1);
    }

    public String getDFAbilityForLevel(int driveFormLevel) {
        if (driveFormLevel < 1) {
            return "";
        }
        return this.data.getDFAbilityForLevel(driveFormLevel - 1);
    }

    public int getLevelUpCost(int level) {
        if (this.getLevelUpCosts() != null) {
            return this.getLevelUpCosts()[level - 1];
        }
        return -1;
    }

    public int getLevelFromExp(int exp) {
        for (int i = 0; i < this.getLevelUpCosts().length; ++i) {
            if (this.getLevelUpCosts()[i] <= exp) continue;
            return i;
        }
        return this.getMaxLevel();
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean getBaseGrowthAbilities() {
        return this.baseGrowth;
    }

    public void setBaseGrowthAbilities(boolean growthAbilities) {
        this.baseGrowth = growthAbilities;
    }

    public void initDrive(Player player) {
        if (!this.getRegistryName().equals((Object)NONE)) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            playerData.setActiveDriveForm(this.getName());
            int cost = ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.getName()))).getDriveCost();
            playerData.remDP(cost);
            playerData.setFP(300 + playerData.getDriveFormLevel(playerData.getActiveDriveForm()) * 100);
            playerData.setAntiPoints(playerData.getAntiPoints() + this.getFormAntiPoints());
            player.m_5634_((float)ModConfigs.driveHeal * player.m_21233_() / 100.0f);
            playerData.setMP(playerData.getMaxMP());
            if (this.getDriveSound() != null) {
                player.m_9236_().m_5594_(null, player.m_20183_(), this.getDriveSound(), SoundSource.MASTER, 1.0f, 1.0f);
            }
            this.pushEntities(player);
            PacketHandler.syncToAllAround(player, playerData);
        }
    }

    public SoundEvent getDriveSound() {
        return (SoundEvent)ModSounds.drive.get();
    }

    public SoundEvent getRevertSound() {
        return (SoundEvent)ModSounds.unsummon.get();
    }

    public void pushEntities(Player player) {
        List list = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82377_(4.0, 3.0, 4.0));
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity e = (Entity)list.get(i);
                if (!(e instanceof LivingEntity)) continue;
                double d = e.m_20185_() - player.m_20185_();
                double d1 = e.m_20189_() - player.m_20189_();
                ((LivingEntity)e).m_147240_(1.0, -d, -d1);
                e.m_20334_(e.m_20184_().f_82479_, (double)0.7f, e.m_20184_().f_82481_);
            }
        }
    }

    public void updateDrive(Player player) {
        if (!this.getRegistryName().equals((Object)NONE)) {
            double formDecrease = 0.2;
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            for (int i = 0; i < playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_form_boost"); ++i) {
                formDecrease /= 1.2;
            }
            if (playerData.getFP() > 0.0) {
                playerData.setFP(playerData.getFP() - formDecrease);
            } else {
                this.endDrive(player);
            }
        }
    }

    public void endDrive(Player player) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        playerData.setActiveDriveForm(NONE.toString());
        if (this.getRevertSound() != null) {
            player.m_9236_().m_5594_(player, player.m_20183_(), this.getRevertSound(), SoundSource.MASTER, 1.0f, 1.0f);
        }
        if (!player.m_9236_().f_46443_) {
            PacketHandler.syncToAllAround(player, playerData);
        }
    }

    public float getStrMult() {
        return this.data.strMult;
    }

    public float getMagMult() {
        return this.data.magMult;
    }

    public float getSpeedMult() {
        return this.data.speedMult;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public boolean canGoAnti() {
        return this.data.canGoAnti;
    }

    public boolean canUseMagic() {
        return this.data.canUseMagic;
    }

    public boolean isSlotVisible(Player player) {
        return this.hasKeychain();
    }

    public boolean displayInCommandMenu(Player player) {
        return true;
    }
}

