/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOrgPortalTPPacket;

public class OrgPortalEntity
extends Entity
implements IEntityAdditionalSpawnData {
    int maxTicks = 100;
    float radius = 0.5f;
    BlockPos destinationPos;
    ResourceKey<Level> destinationDim;
    boolean shouldTeleport;

    public OrgPortalEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public OrgPortalEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
    }

    public OrgPortalEntity(Level world, BlockPos spawnPos, BlockPos destinationPos, ResourceKey<Level> destinationDim, boolean shouldTP) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
        this.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        this.destinationPos = destinationPos;
        this.destinationDim = destinationDim;
        this.shouldTeleport = shouldTP;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() - 1.0 + this.f_19796_.m_188500_() * 2.0, this.m_20186_() + this.f_19796_.m_188500_() * 4.0, this.m_20189_() - 1.0 + this.f_19796_.m_188500_() * 2.0, 0.0, 0.0, 0.0);
        List tempList = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_((double)this.radius, (double)this.radius, (double)this.radius));
        for (Entity t : tempList) {
            if (!this.shouldTeleport || t instanceof OrgPortalEntity) continue;
            if (!this.m_6084_()) {
                return;
            }
            if (t == null || this.destinationPos == null || this.destinationPos.m_123341_() == 0 || this.destinationPos.m_123342_() == 0 || this.destinationPos.m_123343_() == 0) continue;
            double yOffset = t.m_20186_() - this.m_20186_();
            t.m_6034_((double)this.destinationPos.m_123341_() + 0.5, (double)(this.destinationPos.m_123342_() + 1) + yOffset, (double)this.destinationPos.m_123343_() + 0.5);
            if (!(t instanceof Player) || !this.m_9236_().f_46443_) continue;
            PacketHandler.sendToServer(new CSOrgPortalTPPacket(this.destinationDim, (double)this.destinationPos.m_123341_() + 0.5, (double)(this.destinationPos.m_123342_() + 1) + yOffset, (double)this.destinationPos.m_123343_() + 0.5));
        }
        super.m_8119_();
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    protected void m_8097_() {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.destinationPos == null) {
            return;
        }
        buffer.m_130064_(new BlockPos(this.destinationPos.m_123341_(), this.destinationPos.m_123342_(), this.destinationPos.m_123343_()));
        buffer.m_130085_(this.destinationDim.m_135782_());
        buffer.writeBoolean(this.shouldTeleport);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.destinationPos = additionalData.m_130135_();
        this.destinationDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)additionalData.m_130281_());
        this.shouldTeleport = additionalData.readBoolean();
    }
}

