/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class BlizzardEntity
extends ThrowableProjectile {
    int maxTicks = 120;
    float dmgMult = 1.0f;
    int freezeTime;

    public BlizzardEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public BlizzardEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_BLIZZARD.get(), world);
    }

    public BlizzardEntity(Level world, LivingEntity player, float dmgMult, int freezeTime) {
        super((EntityType)ModEntities.TYPE_BLIZZARD.get(), player, world);
        this.dmgMult = dmgMult;
        this.freezeTime = freezeTime;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (ModConfigs.blizzardChangeBlocks && !this.m_9236_().f_46443_) {
            if (this.m_9236_().m_8055_(this.m_20183_()) == Blocks.f_49990_.m_49966_()) {
                this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_50126_.m_49966_());
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else if (this.m_9236_().m_8055_(this.m_20183_()) == Blocks.f_49991_.m_49966_()) {
                this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_50080_.m_49966_());
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (this.f_19797_ > 2) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
        if (!this.m_9236_().f_46443_) {
            LivingEntity target;
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && (entity = ertResult.m_82443_()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.m_19749_()) {
                Party p = null;
                if (this.m_19749_() != null) {
                    p = ModCapabilities.getWorld(this.m_19749_().m_9236_()).getPartyFromMember(this.m_19749_().m_20148_());
                }
                if (p == null || p.getMember(target.m_20148_()) == null || p.getFriendlyFire()) {
                    float f;
                    Entity entity2 = this.m_19749_();
                    if (entity2 instanceof Player) {
                        Player player = (Player)entity2;
                        f = DamageCalculation.getMagicDamage(player) * 0.3f;
                    } else {
                        f = 2.0f;
                    }
                    float dmg = f;
                    target.f_19802_ = 0;
                    target.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.ICE, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                    if (!target.m_6060_()) {
                        MobEffectInstance freeze = target.m_21124_((MobEffect)ModMobEffects.FREEZE.get());
                        int duration = this.freezeTime;
                        if (freeze != null) {
                            duration += freeze.m_19557_();
                        }
                        target.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.FREEZE.get(), duration, 0, false, false, false));
                    }
                }
            }
            if (brtResult != null) {
                BlockPos blockpos = brtResult.m_82425_();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (blockstate.m_61138_((Property)BlockStateProperties.f_61443_)) {
                    this.m_9236_().m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 11);
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    protected void m_8097_() {
    }
}

