/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class BlizzazaEntity
extends ThrowableProjectile {
    int maxTicks = 120;
    float dmgMult = 1.0f;
    float radius = 6.0f;

    public BlizzazaEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public BlizzazaEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_BLIZZAZA.get(), world);
    }

    public BlizzazaEntity(Level world, LivingEntity player, float dmgMult) {
        super((EntityType)ModEntities.TYPE_BLIZZAZA.get(), player, world);
        this.dmgMult = dmgMult;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (ModConfigs.blizzardChangeBlocks && !this.m_9236_().f_46443_ && this.m_9236_().m_8055_(this.m_20183_()) != Blocks.f_50016_.m_49966_()) {
            int x = (int)(this.m_20185_() - (double)(this.radius / 2.0f));
            while ((double)x < this.m_20185_() + (double)(this.radius / 2.0f)) {
                int y = (int)this.m_20186_();
                while ((double)y < this.m_20186_() + 1.0) {
                    int z = (int)(this.m_20189_() - (double)(this.radius / 2.0f));
                    while ((double)z < this.m_20189_() + (double)(this.radius / 2.0f)) {
                        if ((this.m_20185_() - (double)x) * (this.m_20185_() - (double)x) + (this.m_20186_() - (double)y) * (this.m_20186_() - (double)y) + (this.m_20189_() - (double)z) * (this.m_20189_() - (double)z) <= (double)(this.radius / 2.0f * this.radius / 2.0f)) {
                            BlockPos blockpos = new BlockPos(x, y, z);
                            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                            if (blockstate == Blocks.f_49990_.m_49966_()) {
                                this.m_9236_().m_46597_(blockpos, Blocks.f_50126_.m_49966_());
                            } else if (blockstate == Blocks.f_49991_.m_49966_()) {
                                this.m_9236_().m_46597_(blockpos, Blocks.f_50080_.m_49966_());
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_19797_ > 2) {
            float radius = 0.5f;
            for (int t = 1; t < 360; t += 50) {
                for (int s = 1; s < 360; s += 50) {
                    double x = this.m_20185_() + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = this.m_20189_() + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = this.m_20186_() + (double)radius * Math.cos(Math.toRadians(t));
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
        if (!this.m_9236_().f_46443_) {
            Entity ogBlockPos;
            LivingEntity target;
            EntityHitResult ertResult;
            Entity entity;
            if (rtRes instanceof EntityHitResult && (entity = (ertResult = (EntityHitResult)rtRes).m_82443_()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.m_19749_()) {
                Party p = null;
                if (this.m_19749_() != null) {
                    p = ModCapabilities.getWorld(this.m_19749_().m_9236_()).getPartyFromMember(this.m_19749_().m_20148_());
                }
                if (p == null || p.getMember(target.m_20148_()) == null || p.getFriendlyFire()) {
                    float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 1.4f : 2.0f;
                    target.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.ICE, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                    if (!target.m_6060_()) {
                        MobEffectInstance freeze = target.m_21124_((MobEffect)ModMobEffects.FREEZE.get());
                        int duration = 200;
                        if (freeze != null) {
                            duration += freeze.m_19557_();
                        }
                        target.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.FREEZE.get(), duration, 0, false, false));
                    }
                }
            }
            if (rtRes instanceof BlockHitResult) {
                BlockHitResult brtResult = (BlockHitResult)rtRes;
                ogBlockPos = brtResult.m_82425_();
                int x = (int)((float)ogBlockPos.m_123341_() - this.radius);
                while ((float)x < (float)ogBlockPos.m_123341_() + this.radius) {
                    int y = (int)((float)ogBlockPos.m_123342_() - this.radius);
                    while ((float)y < (float)ogBlockPos.m_123342_() + this.radius) {
                        int z = (int)((float)ogBlockPos.m_123343_() - this.radius);
                        while ((float)z < (float)ogBlockPos.m_123343_() + this.radius) {
                            BlockPos blockpos = new BlockPos(x, y, z);
                            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                            if (blockstate.m_61138_((Property)BlockStateProperties.f_61443_)) {
                                this.m_9236_().m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 11);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if ((ogBlockPos = this.m_19749_()) instanceof Player) {
                float i;
                Player player = (Player)ogBlockPos;
                List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)this, this.radius);
                int r = 2;
                for (int t = 1; t < 360; t += 20) {
                    for (int s = 1; s < 360; s += 20) {
                        double x = this.m_20185_() + (double)r * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double z = this.m_20189_() + (double)r * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double y = this.m_20186_() + (double)r * Math.cos(Math.toRadians(t));
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                for (i = -5.0f; i <= 5.0f; i += 0.5f) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + (double)i, this.m_20189_(), 3, 0.0, 0.0, 0.0, 0.2);
                }
                for (i = -5.0f; i <= 5.0f; i += 0.5f) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)i, this.m_20186_(), this.m_20189_(), 3, 0.0, 0.0, 0.0, 0.2);
                }
                for (i = -5.0f; i <= 5.0f; i += 0.5f) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_() + (double)i, 3, 0.0, 0.0, 0.0, 0.2);
                }
                Party casterParty = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
                if (!list.isEmpty()) {
                    for (LivingEntity e : list) {
                        if (e.m_6060_()) {
                            e.m_20095_();
                            continue;
                        }
                        if (Utils.isEntityInParty(casterParty, (Entity)e) || e == this.m_19749_()) continue;
                        float baseDmg = DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 1.4f;
                        float dmg = this.m_19749_() instanceof Player ? baseDmg : 2.0f;
                        e.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.ICE, (Entity)this, (Entity)player), dmg);
                    }
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    protected void m_8097_() {
    }
}

