/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ThunderBoltEntity
extends ThrowableProjectile {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private boolean effectOnly;
    float dmgMult = 1.0f;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(ThunderBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public ThunderBoltEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public ThunderBoltEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), world);
    }

    public ThunderBoltEntity(Level world, Player player, double x, double y, double z, float dmgMult) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.f_19811_ = true;
        this.m_7678_(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.f_19796_.m_188505_();
        this.boltLivingTime = this.f_19796_.m_188503_(3) + 1;
        this.effectOnly = false;
        this.dmgMult = dmgMult;
    }

    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else if (this.lightningState < -this.f_19796_.m_188503_(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.f_19796_.m_188505_();
            }
        }
        if (this.lightningState >= 0 && this.m_19749_() != null) {
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_6580_(2);
            } else if (!this.effectOnly) {
                List<LivingEntity> list;
                float radius = 1.0f;
                Entity entity = this.m_19749_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    list = Utils.getLivingEntitiesInRadiusExcludingParty(player, (Entity)this, radius, 10.0f, radius);
                } else {
                    list = Utils.getLivingEntitiesInRadius((Entity)this, radius);
                }
                for (LivingEntity entity2 : list) {
                    float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.02f : 2.0f;
                    entity2.f_19802_ = 0;
                    entity2.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.LIGHTNING, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                    if (entity2 instanceof Pig && this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                        Pig pig = (Pig)entity2;
                        ZombifiedPiglin zombifiedpiglinentity = (ZombifiedPiglin)EntityType.f_20531_.m_20615_(this.m_9236_());
                        zombifiedpiglinentity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
                        zombifiedpiglinentity.m_7678_(pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), pig.m_146908_(), pig.m_146909_());
                        zombifiedpiglinentity.m_21557_(pig.m_21525_());
                        zombifiedpiglinentity.m_6863_(pig.m_6162_());
                        if (pig.m_8077_()) {
                            zombifiedpiglinentity.m_6593_(pig.m_7770_());
                            zombifiedpiglinentity.m_20340_(pig.m_20151_());
                        }
                        zombifiedpiglinentity.m_21530_();
                        this.m_9236_().m_7967_((Entity)zombifiedpiglinentity);
                        pig.m_142687_(Entity.RemovalReason.KILLED);
                    }
                    if (entity2 instanceof Villager && this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                        Villager villager = (Villager)entity2;
                        Witch witchentity = (Witch)EntityType.f_20495_.m_20615_(this.m_9236_());
                        witchentity.m_7678_(villager.m_20185_(), villager.m_20186_(), villager.m_20189_(), villager.m_146908_(), villager.m_146909_());
                        witchentity.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(witchentity.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
                        witchentity.m_21557_(villager.m_21525_());
                        if (villager.m_8077_()) {
                            witchentity.m_6593_(villager.m_7770_());
                            witchentity.m_20340_(villager.m_20151_());
                        }
                        witchentity.m_21530_();
                        this.m_9236_().m_7967_((Entity)witchentity);
                        villager.m_142687_(Entity.RemovalReason.KILLED);
                    }
                    if (!(entity2 instanceof Creeper)) continue;
                    LightningBolt lightningBoltEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    lightningBoltEntity.m_20219_(Vec3.m_82539_((Vec3i)entity2.m_20183_()));
                    lightningBoltEntity.m_20879_(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
                    this.m_9236_().m_7967_((Entity)lightningBoltEntity);
                }
                if (this.getCaster() != null) {
                    CriteriaTriggers.f_10554_.m_21721_((ServerPlayer)this.getCaster(), list);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 64.0 * ThunderBoltEntity.m_20150_();
        return distance < d0 * d0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(Util.f_137441_));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6532_(HitResult result) {
    }
}

