/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.MagnetEntity;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class WatergaEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    Player player;
    String caster;
    float dmgMult = 1.0f;
    double a = 0.0;
    private static final EntityDataAccessor<String> CASTER = SynchedEntityData.m_135353_(MagnetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public WatergaEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public WatergaEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_WATERGA.get(), world);
    }

    public WatergaEntity(Level world, Player player, float dmgMult) {
        super((EntityType)ModEntities.TYPE_WATERGA.get(), (LivingEntity)player, world);
        this.player = player;
        this.dmgMult = dmgMult;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        for (Player playerFromList : this.m_9236_().m_6907_()) {
            if (!playerFromList.m_5446_().getString().equals(this.getCaster())) continue;
            this.player = playerFromList;
            break;
        }
        if (this.player == null) {
            return;
        }
        if (this.f_19797_ > this.maxTicks || this.player == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_19797_ <= 1) {
            this.m_20334_(0.0, 0.0, 0.0);
        } else if (this.f_19797_ < 25) {
            List list;
            this.m_6034_(this.player.m_20185_(), this.m_20186_(), this.player.m_20189_());
            double radius = 1.4;
            double cx = this.m_20185_();
            double cy = this.m_20186_();
            double cz = this.m_20189_();
            this.a += 100.0;
            double x = cx + radius * Math.cos(Math.toRadians(this.a));
            double z = cz + radius * Math.sin(Math.toRadians(this.a));
            double x2 = cx + radius * Math.cos(Math.toRadians(-this.a));
            double z2 = cz + radius * Math.sin(Math.toRadians(-this.a));
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123803_, x, cy + 0.5 - this.a / 1080.0, z, 1, 0.0, 0.0, 0.0, 0.5);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123776_, x2, cy + 0.5 - this.a / 1080.0, z2, 1, 0.0, 0.0, 0.0, 0.5);
            }
            if (!(list = this.m_9236_().m_6249_((Entity)this.player, this.player.m_20191_().m_82400_(radius), Entity::m_6084_)).isEmpty() && list.get(0) != this) {
                float baseDmg = DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.6f;
                float dmg = this.m_19749_() instanceof Player ? baseDmg : 2.0f;
                for (Entity e : list) {
                    if (!(e instanceof LivingEntity)) continue;
                    e.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.WATER, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                }
            }
        } else {
            this.m_37251_((Entity)this.player, this.player.m_146909_(), this.player.m_146908_(), 0.0f, 2.0f, 0.0f);
            this.player.m_9236_().m_5594_(null, this.player.m_20183_(), SoundEvents.f_12279_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.f_19864_ = true;
            float radius = 0.4f;
            for (int t = 1; t < 360; t += 30) {
                for (int s = 1; s < 360; s += 30) {
                    double x = this.m_20185_() + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = this.m_20189_() + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = this.m_20186_() + (double)radius * Math.cos(Math.toRadians(t));
                    if (this.m_9236_().f_46443_) continue;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123776_, x, y, z, 1, 0.0, 0.0, 0.0, 0.5);
                }
            }
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
        if (!this.m_9236_().f_46443_) {
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && ertResult.m_82443_() != null && ertResult.m_82443_() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)ertResult.m_82443_();
                if (target.m_6060_()) {
                    target.m_20095_();
                } else if (target != this.m_19749_()) {
                    Party p = null;
                    if (this.m_19749_() != null) {
                        p = ModCapabilities.getWorld(this.m_19749_().m_9236_()).getPartyFromMember(this.m_19749_().m_20148_());
                    }
                    if (p == null || p.getMember(target.m_20148_()) == null || p.getFriendlyFire()) {
                        float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.6f : 2.0f;
                        target.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.WATER, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                        this.m_142687_(Entity.RemovalReason.KILLED);
                    }
                }
            }
            float radius = 2.0f;
            if (brtResult != null) {
                BlockPos ogBlockPos = brtResult.m_82425_();
                int x = (int)((float)ogBlockPos.m_123341_() - radius);
                while ((float)x < (float)ogBlockPos.m_123341_() + radius) {
                    int y = (int)((float)ogBlockPos.m_123342_() - radius);
                    while ((float)y < (float)ogBlockPos.m_123342_() + radius) {
                        int z = (int)((float)ogBlockPos.m_123343_() - radius);
                        while ((float)z < (float)ogBlockPos.m_123343_() + radius) {
                            BlockPos blockpos = new BlockPos(x, y, z);
                            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                            if (blockstate.m_61138_((Property)BlockStateProperties.f_61443_)) {
                                this.m_9236_().m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 11);
                            }
                            if (blockstate.m_60734_() == Blocks.f_50083_) {
                                this.m_9236_().m_46597_(blockpos, Blocks.f_50016_.m_49966_());
                            }
                            if (blockstate.m_60734_() == Blocks.f_50056_) {
                                this.m_9236_().m_46597_(blockpos, Blocks.f_50057_.m_49966_());
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (this.m_19749_() instanceof Player) {
                List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)this, radius);
                int r = 1;
                while ((float)r <= radius) {
                    for (int t = 1; t < 360; t += 10) {
                        for (int s = 1; s < 360; s += 10) {
                            double x = this.m_20185_() + (double)r * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                            double z = this.m_20189_() + (double)r * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                            double y = this.m_20186_() + (double)r * Math.cos(Math.toRadians(t));
                            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 1, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5, 0.5);
                        }
                    }
                    ++r;
                }
                Party casterParty = ModCapabilities.getWorld(this.player.m_9236_()).getPartyFromMember(this.player.m_20148_());
                if (!list.isEmpty()) {
                    for (LivingEntity e : list) {
                        if (e.m_6060_()) {
                            e.m_20095_();
                            continue;
                        }
                        if (Utils.isEntityInParty(casterParty, (Entity)e) || e == this.player) continue;
                        float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.5f : 2.0f;
                        e.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.WATER, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                    }
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128359_("caster", this.getCaster());
    }

    public void m_7378_(CompoundTag compound) {
        this.setCaster(compound.m_128461_("caster"));
    }

    public String getCaster() {
        return this.caster;
    }

    public void setCaster(String name) {
        this.f_19804_.m_135381_(CASTER, (Object)name);
        this.caster = name;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(CASTER)) {
            this.caster = this.getCasterDataManager();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CASTER, (Object)"");
    }

    public String getCasterDataManager() {
        return (String)this.f_19804_.m_135370_(CASTER);
    }
}

