/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.util.Utils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BloxBugEntity
extends PathfinderMob
implements GeoEntity,
IKHMob,
IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(BloxBugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    boolean fromBlock;
    public static final int IDLE = 0;
    public static final int SPAWN = 1;
    public static final int SPAWN_BLOCK = 2;
    public static final int WALKING = 3;
    public static final int JUMPING = 4;
    public static final int CHARGE = 5;
    public static final int JUMP_ATTACK = 6;
    public static final int COOLDOWN = 7;
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation SPAWN_ANIM = RawAnimation.begin().thenPlay("spawn");
    protected static final RawAnimation SPAWN_BLOCK_ANIM = RawAnimation.begin().thenPlay("spawn_block");
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("walk");
    protected static final RawAnimation CHARGE_READY_ANIM = RawAnimation.begin().thenPlayAndHold("charge_ready");
    protected static final RawAnimation CHARGE_LOOP_ANIM = RawAnimation.begin().thenLoop("charge_loop");
    protected static final RawAnimation CHARGE_STOP_ANIM = RawAnimation.begin().thenPlay("charge_stop");
    protected static final RawAnimation JUMP_ANIM = RawAnimation.begin().thenPlayAndHold("jump");
    protected static final RawAnimation JUMP_ATTACK_PREPARE_ANIM = RawAnimation.begin().thenPlayAndHold("jump_attack_prepare");
    protected static final RawAnimation JUMP_ATTACK_ANIM = RawAnimation.begin().thenLoop("jump_attack");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    int spawnBlockTicks = 0;

    public BloxBugEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BloxBugEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.TYPE_BLOX_BUG.get()), world);
    }

    public BloxBugEntity(Level world, boolean fromBlock) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.TYPE_BLOX_BUG.get()), world);
        this.fromBlock = fromBlock;
        if (fromBlock) {
            this.setState(2);
        } else {
            this.setState(1);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, this::animController)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "anims", 0, state -> PlayState.STOP).triggerableAnim("idle", IDLE_ANIM).triggerableAnim("spawn", SPAWN_ANIM).triggerableAnim("spawn_block", SPAWN_BLOCK_ANIM).triggerableAnim("walk", WALK_ANIM).triggerableAnim("charge_ready", CHARGE_READY_ANIM).triggerableAnim("charge_loop", CHARGE_LOOP_ANIM).triggerableAnim("charge_stop", CHARGE_STOP_ANIM).triggerableAnim("jump", JUMP_ANIM).triggerableAnim("jump_attack_prepare", JUMP_ATTACK_PREPARE_ANIM).triggerableAnim("jump_attack", JUMP_ATTACK_ANIM)});
    }

    protected <E extends BloxBugEntity> PlayState animController(AnimationState<GeoAnimatable> state) {
        switch (this.getState()) {
            case 2: {
                state.getController().setAnimation(SPAWN_BLOCK_ANIM);
                return PlayState.CONTINUE;
            }
            case 3: {
                state.getController().setAnimation(WALK_ANIM);
                return PlayState.CONTINUE;
            }
            case 5: {
                state.getController().setAnimation(CHARGE_LOOP_ANIM);
                return PlayState.CONTINUE;
            }
            case 6: {
                state.getController().setAnimation(JUMP_ATTACK_ANIM);
                return PlayState.CONTINUE;
            }
            case 4: {
                state.getController().setAnimation(JUMP_ANIM);
                return PlayState.CONTINUE;
            }
            case 0: {
                state.getController().setAnimation(IDLE_ANIM);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void m_8099_() {
        MoveTowardsTargetGoal moveTowardsTargetGoal = new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 35.0f);
        WaterAvoidingRandomStrollGoal waterAvoidingRandomStrollGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0);
        BloxBugGoal bloxBugGoal = new BloxBugGoal(this);
        this.f_21345_.m_25352_(7, (Goal)moveTowardsTargetGoal);
        this.f_21345_.m_25352_(9, (Goal)waterAvoidingRandomStrollGoal);
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21345_.m_25352_(3, (Goal)bloxBugGoal);
        waterAvoidingRandomStrollGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        bloxBugGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return PathfinderMob.m_21183_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getState() == 2) {
            ++this.spawnBlockTicks;
        }
        if (this.spawnBlockTicks > 31) {
            this.spawnBlockTicks = 0;
            this.setState(0);
        }
        if (this.getState() == 3 || this.getState() == 0) {
            if ((this.f_19790_ != this.m_20185_() || this.f_19792_ != this.m_20189_()) && this.m_20096_()) {
                this.setState(3);
            } else {
                this.setState(0);
            }
        }
        if (this.getState() == 4 && !this.f_20899_) {
            this.setState(3);
        }
        if (this.f_20899_) {
            this.setState(4);
        }
        if (this.m_5448_() == null) {
            if (this.getState() == 5 || this.getState() == 6) {
                this.setState(0);
                this.stopTriggeredAnimation("anims", "charge_loop");
            }
            if (this.getState() == 7) {
                // empty if block
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }

    @Override
    public int getDefense() {
        return 0;
    }

    public void setState(int i) {
        this.f_19804_.m_135381_(STATE, (Object)i);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void writeSpawnData(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.fromBlock);
    }

    public void readSpawnData(FriendlyByteBuf friendlyByteBuf) {
        this.fromBlock = friendlyByteBuf.readBoolean();
    }

    public static class BloxBugGoal
    extends Goal {
        BloxBugEntity instance;
        Vec3 targetPosCache;
        Vec3 targetDirection;
        int attackTicks;
        int cooldownTicks;
        int prepareTicks;
        final int attackDelay = 60;
        final int attackDelayVariance = 40;
        final int chargeDistance = 10;
        final int cooldownLength = 10;
        final int prepareLength = 10;
        float startDist;
        int nextAttack = 60 + Utils.randomWithRange(-40, 40);

        public BloxBugGoal(BloxBugEntity instance) {
            this.instance = instance;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            LivingEntity target = this.instance.m_5448_();
            switch (this.instance.getState()) {
                case 0: 
                case 3: {
                    if (target == null) break;
                    ++this.attackTicks;
                    if (this.attackTicks > this.nextAttack) {
                        this.targetDirection = new Vec3((double)((float)(target.m_20182_().m_7096_() - this.instance.m_20182_().m_7096_())), (double)((float)(target.m_20182_().m_7098_() - this.instance.m_20182_().m_7098_())), (double)((float)(target.m_20182_().m_7094_() - this.instance.m_20182_().m_7094_()))).m_82541_();
                        if (target.m_20182_().f_82480_ > this.instance.m_20182_().f_82480_ || !this.instance.m_20229_(this.targetDirection.f_82479_, this.targetDirection.f_82480_, this.targetDirection.f_82481_)) {
                            this.instance.setState(6);
                            this.instance.triggerAnim("anims", "jump");
                            this.attackTicks = 0;
                            this.prepareTicks = 8;
                            this.nextAttack = 60 + Utils.randomWithRange(-40, 40);
                            break;
                        }
                        if (!(target.m_20182_().f_82480_ <= this.instance.m_20182_().f_82480_) || !this.instance.m_20229_(this.targetDirection.f_82479_, this.targetDirection.f_82480_, this.targetDirection.f_82481_) || !(target.m_20270_((Entity)this.instance) < 20.0f)) break;
                        this.instance.setState(5);
                        this.instance.triggerAnim("anims", "charge_ready");
                        this.attackTicks = 0;
                        this.prepareTicks = 10;
                        this.instance.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.nextAttack = 60 + Utils.randomWithRange(-40, 40);
                        break;
                    }
                    if (target.m_19950_((Entity)this.instance, 2.0)) {
                        target.m_6469_(this.instance.m_269291_().m_269333_((LivingEntity)this.instance), (float)this.instance.m_21133_(Attributes.f_22281_));
                        this.instance.triggerAnim("anims", "charge_loop");
                        break;
                    }
                    this.instance.stopTriggeredAnimation("anims", "charge_loop");
                    break;
                }
                case 5: {
                    if (this.prepareTicks <= 0) {
                        if (this.instance.m_20182_().f_82480_ < this.targetPosCache.f_82480_ || this.instance.f_19787_ - this.startDist >= 10.0f || !this.instance.m_20229_(this.targetDirection.f_82479_, this.targetDirection.f_82480_, this.targetDirection.f_82481_)) {
                            this.instance.setState(7);
                            this.cooldownTicks = 10;
                            this.instance.stopTriggeredAnimation("anims", "charge_loop");
                            this.instance.triggerAnim("anims", "charge_stop");
                            this.targetPosCache = null;
                            break;
                        }
                        this.instance.triggerAnim("anims", "charge_loop");
                        this.instance.m_20256_(new Vec3(this.targetDirection.f_82479_, this.instance.m_20184_().f_82480_, this.targetDirection.f_82481_).m_82490_(2.0));
                        this.instance.m_9236_().m_45933_((Entity)this.instance, this.instance.m_20191_().m_82400_(2.0)).forEach(entity -> {
                            entity.m_6469_(this.instance.m_269291_().m_269333_((LivingEntity)this.instance), (float)this.instance.m_21133_(Attributes.f_22281_) + 4.0f);
                            entity.m_5997_(this.targetDirection.f_82479_ * 7.0, 0.3, this.targetDirection.f_82481_ * 7.0);
                        });
                        break;
                    }
                    if (target != null) {
                        this.targetPosCache = target.m_20182_();
                    }
                    if (this.targetPosCache == null) break;
                    this.targetDirection = new Vec3((double)((float)(this.targetPosCache.m_7096_() - this.instance.m_20182_().m_7096_())), 0.0, (double)((float)(this.targetPosCache.m_7094_() - this.instance.m_20182_().m_7094_()))).m_82541_();
                    if (!this.instance.m_20229_(this.targetDirection.f_82479_, this.targetDirection.f_82480_, this.targetDirection.f_82481_) && this.targetPosCache.m_82554_(this.instance.m_20182_()) > 20.0) {
                        this.instance.setState(0);
                        this.instance.stopTriggeredAnimation("anims", "charge_ready");
                    }
                    --this.prepareTicks;
                    this.instance.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPosCache);
                    if (this.prepareTicks > 0) break;
                    this.startDist = this.instance.f_19787_;
                    break;
                }
                case 6: {
                    if (this.prepareTicks <= 0) {
                        if (!this.instance.m_20229_(this.targetDirection.f_82479_, this.targetDirection.f_82480_, this.targetDirection.f_82481_)) {
                            this.cooldownTicks = 4;
                            this.instance.setState(7);
                            this.instance.m_183634_();
                            this.targetPosCache = null;
                            this.instance.m_20242_(false);
                            this.instance.m_9236_().m_45933_((Entity)this.instance, this.instance.m_20191_().m_82400_(3.0)).forEach(entity -> entity.m_6469_(this.instance.m_269291_().m_269333_((LivingEntity)this.instance), (float)this.instance.m_21133_(Attributes.f_22281_) + 8.0f));
                            break;
                        }
                        this.instance.m_20242_(false);
                        this.instance.m_20256_(new Vec3(this.targetDirection.f_82479_, this.targetDirection.f_82480_ > 1.0 ? 1.0 : this.targetDirection.f_82480_, this.targetDirection.f_82481_).m_82490_(2.0));
                        this.instance.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPosCache);
                        this.instance.m_183634_();
                        this.instance.m_9236_().m_45933_((Entity)this.instance, this.instance.m_20191_().m_82400_(2.0)).forEach(entity -> entity.m_6469_(this.instance.m_269291_().m_269333_((LivingEntity)this.instance), (float)(this.instance.m_21133_(Attributes.f_22281_) + 8.0)));
                        break;
                    }
                    if (target != null) {
                        this.targetPosCache = target.m_20182_();
                    }
                    this.targetDirection = new Vec3((double)((float)(this.targetPosCache.m_7096_() - this.instance.m_20182_().m_7096_())), (double)((float)(this.targetPosCache.m_7098_() - this.instance.m_20182_().m_7098_())), (double)((float)(this.targetPosCache.m_7094_() - this.instance.m_20182_().m_7094_()))).m_82541_();
                    --this.prepareTicks;
                    this.instance.m_20242_(true);
                    this.instance.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPosCache);
                    this.instance.f_21365_.m_24964_(this.targetPosCache);
                    if (this.prepareTicks >= 4) {
                        this.instance.m_20256_(new Vec3(0.0, 1.0, 0.0));
                    }
                    if (this.prepareTicks < 4) {
                        this.instance.triggerAnim("anims", "jump_attack_prepare");
                        this.instance.m_20256_(new Vec3(0.0, 0.0, 0.0));
                    }
                    if (this.prepareTicks > 0) break;
                    this.instance.triggerAnim("anims", "jump_attack");
                    break;
                }
                case 7: {
                    --this.cooldownTicks;
                    if (this.cooldownTicks > 0) break;
                    this.instance.setState(0);
                    this.instance.stopTriggeredAnimation("anims", "jump_attack");
                    this.instance.stopTriggeredAnimation("anims", "charge_stop");
                }
            }
            if (target != null) {
                if (this.instance.getState() != 0 && this.instance.getState() != 3) {
                    this.instance.f_21345_.m_148105_().forEach(wrappedGoal -> {
                        if (wrappedGoal.m_26015_().getClass() == WaterAvoidingRandomStrollGoal.class || wrappedGoal.m_26015_().getClass() == RandomLookAroundGoal.class || wrappedGoal.m_26015_().getClass() == MoveTowardsTargetGoal.class) {
                            wrappedGoal.m_8041_();
                            this.instance.m_21573_().m_26573_();
                        }
                    });
                } else {
                    this.instance.f_21345_.m_148105_().forEach(wrappedGoal -> {
                        if ((wrappedGoal.m_26015_().getClass() == WaterAvoidingRandomStrollGoal.class || wrappedGoal.m_26015_().getClass() == RandomLookAroundGoal.class || wrappedGoal.m_26015_().getClass() == MoveTowardsTargetGoal.class) && wrappedGoal.m_8036_()) {
                            wrappedGoal.m_8056_();
                        }
                    });
                }
            }
            if (this.targetPosCache == null && target == null) {
                this.instance.m_20242_(false);
                this.instance.setState(0);
                this.instance.f_21345_.m_148105_().forEach(wrappedGoal -> {
                    if ((wrappedGoal.m_26015_().getClass() == WaterAvoidingRandomStrollGoal.class || wrappedGoal.m_26015_().getClass() == RandomLookAroundGoal.class) && wrappedGoal.m_8036_()) {
                        wrappedGoal.m_8056_();
                    }
                });
            }
            return true;
        }
    }
}

