/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;

public class ArrowRainCoreEntity
extends ThrowableProjectile {
    int maxTicks = 240;
    float dmg;
    float radius;
    float space;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(ArrowRainCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.m_135353_(ArrowRainCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public ArrowRainCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public ArrowRainCoreEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_ARROW_RAIN.get(), world);
    }

    public ArrowRainCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super((EntityType)ModEntities.TYPE_ARROW_RAIN.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.setTarget(target.m_20148_());
        this.dmg = dmg;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks || this.getCaster() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_20334_(0.0, 0.0, 0.0);
        this.f_19864_ = true;
        double X = this.m_20185_();
        double Y = this.m_20186_();
        double Z = this.m_20189_();
        if (this.getCaster() != null) {
            if (this.f_19797_ == 1) {
                LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.m_9236_(), (LivingEntity)this.getCaster(), this.dmg);
                bullet.m_6034_(X, Y, Z);
                bullet.setMaxTicks(30);
                bullet.m_6686_(0.0, 255.0, 0.0, 1.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)bullet);
                this.m_9236_().m_5594_(this.getCaster(), this.getCaster().m_20183_(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundSource.PLAYERS, 1.0f, 0.6f);
            } else if (this.f_19797_ > 40 && this.f_19797_ % 2 == 0) {
                this.radius = Math.min((float)(this.f_19797_ - 34) / 10.0f, 20.0f);
                this.space = 26.0f - this.radius;
                int s = 1;
                while (s < 360) {
                    double x = X + (double)this.radius * Math.cos(Math.toRadians(s));
                    double z = Z + (double)this.radius * Math.sin(Math.toRadians(s));
                    LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.m_9236_(), (LivingEntity)this.getCaster(), this.dmg);
                    bullet.m_6034_(X, Y + 27.0, Z);
                    bullet.setMaxTicks(20);
                    bullet.m_6686_(x - bullet.m_20185_(), this.m_20186_() - bullet.m_20186_() + 1.0, z - bullet.m_20189_(), 2.5f, 0.0f);
                    this.m_9236_().m_7967_((Entity)bullet);
                    s = (int)((float)s + this.space);
                }
                this.m_9236_().m_5594_(this.getCaster(), this.getCaster().m_20183_(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
            compound.m_128359_("TargetUUID", ((UUID)((Optional)this.f_19804_.m_135370_(TARGET)).get()).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
        this.f_19804_.m_135381_(TARGET, Optional.of(UUID.fromString(compound.m_128461_("TargetUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    public Player getTarget() {
        return ((Optional)this.m_20088_().m_135370_(TARGET)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.f_19804_.m_135381_(TARGET, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

