/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class LaserDomeCoreEntity
extends ThrowableProjectile {
    int maxTicks = 240;
    List<LaserDomeShotEntity> list = new ArrayList<LaserDomeShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    Set<Integer> usedIndexes = new HashSet<Integer>();
    float dmg;
    float radius = 15.0f;
    int space = 12;
    int shotsPerTick = 3;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(LaserDomeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.m_135353_(LaserDomeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public LaserDomeCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public LaserDomeCoreEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends ThrowableProjectile>)((EntityType)ModEntities.TYPE_LASER_DOME.get()), world);
    }

    public LaserDomeCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super((EntityType)ModEntities.TYPE_LASER_DOME.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.setTarget(target.m_20148_());
        this.dmg = dmg;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks || this.getCaster() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        double X = this.m_20185_();
        double Y = this.m_20186_();
        double Z = this.m_20189_();
        if (this.getCaster() != null) {
            if (this.f_19797_ >= 0 && this.f_19797_ < 20) {
                double t = this.f_19797_ * 5;
                for (int s = 1; s < 360; s += this.space) {
                    double x = X + (double)this.radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = Z + (double)this.radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = Y + (double)this.radius * Math.cos(Math.toRadians(t));
                    LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.m_9236_(), (LivingEntity)this.getCaster(), this.dmg);
                    bullet.m_6034_(x, y, z);
                    bullet.setMaxTicks(this.maxTicks - 20);
                    bullet.m_6686_(this.m_20185_() - bullet.m_20185_(), this.m_20186_() - bullet.m_20186_(), this.m_20189_() - bullet.m_20189_(), 0.001f, 0.0f);
                    this.list.add(bullet);
                    this.m_9236_().m_7967_((Entity)bullet);
                }
                this.m_20334_(0.0, 0.0, 0.0);
                this.f_19864_ = true;
            } else if (this.f_19797_ == 40) {
                this.updateList();
            } else if (this.f_19797_ > 40 && !this.targetList.isEmpty()) {
                if (this.f_19797_ == 80) {
                    this.updateList();
                }
                for (int i = 0; i < this.shotsPerTick; ++i) {
                    int num;
                    while (this.usedIndexes.contains(num = this.f_19796_.m_188503_(this.list.size())) && this.usedIndexes.size() != this.list.size()) {
                    }
                    this.usedIndexes.add(num);
                    LaserDomeCoreEntity target = this;
                    int targetIndex = this.f_19796_.m_188503_(this.targetList.size());
                    target = this.targetList.get(targetIndex);
                    if (target == null || !target.m_6084_() || this.getCaster() == null) continue;
                    LaserDomeShotEntity bullet = this.list.get(num);
                    bullet.m_6686_(target.m_20185_() - (bullet.m_20185_() + this.m_9236_().f_46441_.m_188500_() - 0.5), target.m_20186_() - bullet.m_20186_(), target.m_20189_() - (bullet.m_20189_() + this.m_9236_().f_46441_.m_188500_() - 0.5), 2.0f, 0.0f);
                    this.m_9236_().m_5594_(this.getCaster(), this.getCaster().m_20183_(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
                }
            }
        }
        super.m_8119_();
    }

    private void updateList() {
        List tempList = this.m_9236_().m_45933_((Entity)this.getCaster(), this.m_20191_().m_82377_((double)this.radius, (double)this.radius, (double)this.radius));
        Party casterParty = ModCapabilities.getWorld(this.m_9236_()).getPartyFromMember(this.getCaster().m_20148_());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                tempList.remove(this.m_9236_().m_46003_(m.getUUID()));
            }
        } else {
            tempList.remove(this.m_19749_());
        }
        this.targetList.clear();
        for (Entity t : tempList) {
            if (t instanceof LaserDomeShotEntity || t instanceof ItemDropEntity || t instanceof ItemEntity || t instanceof ExperienceOrb) continue;
            this.targetList.add(t);
        }
    }

    protected void m_6532_(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
            compound.m_128359_("TargetUUID", ((UUID)((Optional)this.f_19804_.m_135370_(TARGET)).get()).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
        this.f_19804_.m_135381_(TARGET, Optional.of(UUID.fromString(compound.m_128461_("TargetUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    public Player getTarget() {
        return ((Optional)this.m_20088_().m_135370_(TARGET)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.f_19804_.m_135381_(TARGET, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

