/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.handler;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.api.event.client.KKInputEvent;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.menu.NoChoiceMenuPopup;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.mob.SpawningOrbEntity;
import online.kingdomkeys.kingdomkeys.handler.KeyboardHelper;
import online.kingdomkeys.kingdomkeys.integration.epicfight.init.KKAnimations;
import online.kingdomkeys.kingdomkeys.lib.Constants;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSExtendedReach;
import online.kingdomkeys.kingdomkeys.network.cts.CSPlayAnimation;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonArmor;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSSyncAllClientDataPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseReactionCommandPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseShortcutPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.IExtendedReach;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;

public class InputHandler {
    @Nullable
    public List<UUID> portalCommands;
    @Nullable
    public List<Party.Member> targetsList;
    @Nullable
    public List<Limit> limitsList;
    @Nullable
    public List<String> magicList;
    @Nullable
    public Map<Integer, ItemStack> itemsList;
    @Nullable
    public List<String> reactionList;
    @Nullable
    public static LivingEntity lockOn = null;
    public static int qrCooldown = 40;
    public Minecraft mc = Minecraft.m_91087_();
    public LocalPlayer player;
    @Nullable
    public ClientLevel level;
    public IPlayerCapabilities playerData;
    public IGlobalCapabilities globalData;
    @Nullable
    public IWorldCapabilities worldData;
    boolean canSwitchTarget = true;
    public static int LOCK_ON_REACH = 35;

    private void init() {
        this.player = this.mc.f_91074_;
        this.level = this.mc.f_91073_;
        if (this.level != null) {
            this.worldData = ModCapabilities.getWorld((Level)this.level);
        }
        if (this.player != null) {
            this.playerData = ModCapabilities.getPlayer((Player)this.player);
            this.globalData = ModCapabilities.getGlobal((LivingEntity)this.player);
        }
    }

    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.Key event) {
        this.init();
        if (lockOn != null) {
            if (this.canSwitchTarget && event.getKey() == this.mc.f_91066_.f_92091_.getKey().m_84873_()) {
                this.switchTarget(this.player.m_6047_());
                this.canSwitchTarget = false;
            } else {
                this.canSwitchTarget = true;
            }
        }
        Keybinds key = this.getPressedKey();
        if (this.player != null) {
            if (this.playerData == null) {
                return;
            }
            if (key != null) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new KKInputEvent.Pre(key, this))) {
                    switch (key) {
                        case OPENMENU: {
                            this.openMenu();
                            break;
                        }
                        case SHOW_GUI: {
                            this.showGui();
                            break;
                        }
                        case SCROLL_UP: {
                            if (this.mc.f_91080_ != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandUp();
                            break;
                        }
                        case SCROLL_DOWN: {
                            if (this.mc.f_91080_ != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandDown();
                            break;
                        }
                        case ENTER: {
                            if (this.mc.f_91080_ != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandEnter();
                            break;
                        }
                        case BACK: {
                            if (this.mc.f_91080_ != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandBack();
                            break;
                        }
                        case SUMMON_KEYBLADE: {
                            this.summonKeyblade();
                            break;
                        }
                        case SUMMON_ARMOR: {
                            this.summonArmor();
                            break;
                        }
                        case ACTION: {
                            this.commandAction();
                            break;
                        }
                        case LOCK_ON: {
                            this.lockOn();
                            break;
                        }
                        case REACTION_COMMAND: {
                            this.reactionCommand();
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new KKInputEvent.Post(key, this));
                }
            } else {
                this.otherKeyPressed(event);
            }
        }
    }

    @SubscribeEvent
    public void handleMouseInputEvent(InputEvent.MouseButton.Pre event) {
        this.init();
        if (this.level != null) {
            if (event.getButton() == 0 && event.getAction() == 1) {
                ItemStack itemstack;
                if (KeyboardHelper.isScrollActivatorDown() && Utils.shouldRenderOverlay((Player)this.player)) {
                    this.commandEnter();
                    event.setCanceled(true);
                } else if (this.mc.f_91080_ == null && this.player != null && !ItemStack.m_41728_((ItemStack)(itemstack = this.player.m_21205_()), (ItemStack)ItemStack.f_41583_)) {
                    EntityHitResult ertr;
                    float reach;
                    HitResult rtr;
                    IExtendedReach ieri;
                    IExtendedReach iExtendedReach = ieri = itemstack.m_41720_() instanceof IExtendedReach ? (IExtendedReach)itemstack.m_41720_() : null;
                    if (ieri != null && (rtr = InputHandler.getMouseOverExtended(reach = ieri.getReach())) != null && rtr instanceof EntityHitResult && (ertr = (EntityHitResult)rtr).m_82443_() != null && ertr.m_82443_().f_19802_ == 0 && ertr.m_82443_() != this.player && !ertr.m_82443_().m_20197_().contains(this.player)) {
                        PacketHandler.sendToServer(new CSExtendedReach(ertr.m_82443_().m_19879_()));
                    }
                }
            }
            if (event.getButton() == 2 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1 && Utils.shouldRenderOverlay((Player)this.player)) {
                this.commandSwapReaction();
                event.setCanceled(true);
            }
            if (event.getButton() == 1 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1 && Utils.shouldRenderOverlay((Player)this.player)) {
                this.commandBack();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void OnMouseWheelScroll(InputEvent.MouseScrollingEvent event) {
        this.init();
        if (this.mc.m_91302_() && KeyboardHelper.isScrollActivatorDown()) {
            event.setCanceled(true);
            if (!Utils.shouldRenderOverlay((Player)this.player)) {
                return;
            }
            if (event.getScrollDelta() == -1.0) {
                this.commandDown();
            } else if (event.getScrollDelta() == 1.0) {
                this.commandUp();
            }
        }
    }

    public void showGui() {
        ModConfigs.toggleGui();
        this.player.m_5661_((Component)Component.m_237110_((String)"message.kingdomkeys.gui_toggle", (Object[])new Object[]{ModConfigs.showGuiToggle.toString()}), true);
    }

    public void openMenu() {
        PacketHandler.sendToServer(new CSSyncAllClientDataPacket());
        if (this.playerData.getSoAState() != SoAState.COMPLETE) {
            if (this.level.m_46472_() != ModDimensions.DIVE_TO_THE_HEART) {
                this.mc.m_91152_((Screen)new NoChoiceMenuPopup());
            }
        } else {
            GuiHelper.openMenu();
        }
    }

    public void summonKeyblade() {
        if (this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            if (KingdomKeys.efmLoaded) {
                if (Utils.findSummoned(this.player.m_150109_(), this.playerData.getEquippedKeychain(DriveForm.NONE)) == -1 && this.playerData.getAlignment() == Utils.OrgMember.NONE) {
                    if (!this.playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade")) {
                        PacketHandler.sendToServer(new CSPlayAnimation(KKAnimations.singleKeybladeMap.get(this.playerData.getSingleStyle())));
                    } else {
                        PacketHandler.sendToServer(new CSPlayAnimation(KKAnimations.dualKeybladeMap.get(this.playerData.getDualStyle())));
                    }
                } else if (Utils.findSummoned(this.player.m_150109_(), this.playerData.getEquippedWeapon()) == -1 && this.playerData.getAlignment() != Utils.OrgMember.NONE) {
                    PacketHandler.sendToServer(new CSPlayAnimation(KKAnimations.orgMap.get((Object)this.playerData.getAlignment())));
                } else {
                    PacketHandler.sendToServer(new CSSummonKeyblade());
                }
            } else {
                PacketHandler.sendToServer(new CSSummonKeyblade());
            }
        } else if (KingdomKeys.efmLoaded && Utils.findSummoned(this.player.m_150109_(), this.playerData.getEquippedKeychain(DriveForm.NONE)) == -1) {
            PacketHandler.sendToServer(new CSPlayAnimation(KKAnimations.DRIVE_SUMMON));
        } else {
            PacketHandler.sendToServer(new CSSummonKeyblade(new ResourceLocation(this.playerData.getActiveDriveForm())));
        }
        if (ModConfigs.summonTogether) {
            PacketHandler.sendToServer(new CSSummonArmor());
        }
    }

    public void summonArmor() {
        PacketHandler.sendToServer(new CSSummonArmor());
    }

    public void lockOn() {
        if (lockOn == null) {
            EntityHitResult ertr;
            double distance;
            HitResult rtr = InputHandler.getMouseOverExtended(LOCK_ON_REACH);
            if (rtr != null && rtr instanceof EntityHitResult && (double)LOCK_ON_REACH >= (distance = (double)this.player.m_20270_((ertr = (EntityHitResult)rtr).m_82443_())) && ertr.m_82443_() instanceof LivingEntity && !(ertr.m_82443_() instanceof SpawningOrbEntity)) {
                lockOn = (LivingEntity)ertr.m_82443_();
                this.playSound((SoundEvent)ModSounds.lockon.get());
            }
        } else {
            lockOn = null;
        }
    }

    private void switchTarget(boolean toRight) {
        int nextIndex;
        LivingEntity nextTarget;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || lockOn == null) {
            return;
        }
        LivingEntity currentTarget = lockOn;
        List candidates = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)((float)LOCK_ON_REACH / 4.0f)), arg_0 -> InputHandler.lambda$switchTarget$0((Player)player, arg_0));
        if (candidates.size() <= 1) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_();
        List<Pair> sorted = candidates.stream().map(entity -> {
            Vec3 dirToEntity = entity.m_20182_().m_82546_(playerPos).m_82541_();
            double angle = Math.toDegrees(Math.atan2(lookVec.f_82481_ * dirToEntity.f_82479_ - lookVec.f_82479_ * dirToEntity.f_82481_, lookVec.f_82479_ * dirToEntity.f_82479_ + lookVec.f_82481_ * dirToEntity.f_82481_));
            return Pair.of((Object)entity, (Object)angle);
        }).sorted(Comparator.comparingDouble(Pair::getSecond)).toList();
        int index = -1;
        for (int i = 0; i < sorted.size(); ++i) {
            if (!((LivingEntity)sorted.get(i).getFirst()).equals((Object)currentTarget)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
        }
        if ((nextTarget = (LivingEntity)sorted.get(nextIndex = (index + (toRight ? 1 : -1) + sorted.size()) % sorted.size()).getFirst()).equals((Object)currentTarget)) {
            return;
        }
        lockOn = nextTarget;
        this.playSound((SoundEvent)ModSounds.lockon.get());
    }

    public void commandUp() {
        CommandMenuGui.up();
    }

    public void commandDown() {
        CommandMenuGui.down();
    }

    public void commandEnter() {
        CommandMenuGui.enter();
    }

    public void commandBack() {
        CommandMenuGui.cancel();
    }

    public void commandAction() {
        if (qrCooldown <= 0 && this.player.m_20184_().f_82479_ != 0.0 && this.player.m_20184_().f_82481_ != 0.0) {
            if (this.player.m_20142_()) {
                if (this.playerData.isAbilityEquipped("kingdomkeys:ability_quick_run") || this.playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
                    this.quickRun();
                }
            } else if (this.playerData.isAbilityEquipped("kingdomkeys:ability_dodge_roll") || this.playerData.getActiveDriveForm().equals("kingdomkeys:form_limit")) {
                this.dodgeRoll();
            }
        }
    }

    public void quickRun() {
        float yaw = this.player.m_146908_();
        float motionX = -Mth.m_14031_((float)(yaw / 180.0f * (float)Math.PI));
        float motionZ = Mth.m_14089_((float)(yaw / 180.0f * (float)Math.PI));
        int wisdomLevel = this.playerData.getDriveFormLevel("kingdomkeys:form_wisdom");
        double power = 0.0;
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.playerData.getActiveDriveForm()));
        if (this.playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
            power = Constants.WISDOM_QR[wisdomLevel];
        } else if ((this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && wisdomLevel > 2) {
            power = Constants.WISDOM_QR[wisdomLevel - 2];
        }
        if (this.player.m_20096_()) {
            this.player.m_5997_((double)motionX * power, 0.0, (double)motionZ * power);
            qrCooldown = 20;
        }
    }

    public void dodgeRoll() {
        int limitLevel = this.playerData.getDriveFormLevel("kingdomkeys:form_limit");
        double power = 0.0;
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.playerData.getActiveDriveForm()));
        if (this.playerData.getActiveDriveForm().equals("kingdomkeys:form_limit")) {
            power = Constants.LIMIT_DR[limitLevel];
        } else if ((this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && limitLevel > 2) {
            power = Constants.LIMIT_DR[limitLevel - 2];
        }
        if (this.player.m_20096_()) {
            this.player.m_5997_(this.player.m_20184_().f_82479_ * power, 0.0, this.player.m_20184_().f_82481_ * power);
            qrCooldown = 20;
        }
    }

    public void commandSwapReaction() {
        this.loadLists();
        if (this.reactionList != null && !this.reactionList.isEmpty()) {
            if (CommandMenuGui.reactionSelected < this.reactionList.size() - 1) {
                ++CommandMenuGui.reactionSelected;
            } else if (CommandMenuGui.reactionSelected >= this.reactionList.size() - 1) {
                CommandMenuGui.reactionSelected = 0;
            }
        }
    }

    public void reactionCommand() {
        this.loadLists();
        if (!this.reactionList.isEmpty()) {
            PacketHandler.sendToServer(new CSUseReactionCommandPacket(CommandMenuGui.reactionSelected, lockOn));
            String reactionName = this.playerData.getReactionCommands().get(CommandMenuGui.reactionSelected);
            ReactionCommand reaction = (ReactionCommand)ModReactionCommands.registry.get().getValue(new ResourceLocation(reactionName));
            CommandMenuGui.reactionSelected = 0;
            if (reaction != null) {
                this.playSound(reaction.getUseSound((Player)this.player, lockOn));
            } else {
                this.playInSound();
            }
        }
    }

    public void otherKeyPressed(InputEvent.Key event) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.playerData.getActiveDriveForm()));
        if (KeyboardHelper.isScrollActivatorDown() && event.getKey() > 320 && event.getKey() < 330 && this.globalData != null && !this.player.m_21023_((MobEffect)ModMobEffects.STOP.get()) && this.playerData.getMagicCasttimeTicks() <= 0 && this.playerData.getMagicCooldownTicks() <= 0 && !this.playerData.getRecharge() && form.canUseMagic() && !this.player.m_21023_((MobEffect)ModMobEffects.KO.get())) {
            PacketHandler.sendToServer(new CSUseShortcutPacket(event.getKey() - 321, lockOn));
        }
        if (KeyboardHelper.isScrollActivatorDown() && event.getKey() > 48 && event.getKey() < 58 && this.globalData != null && !this.player.m_21023_((MobEffect)ModMobEffects.STOP.get()) && this.playerData.getMagicCasttimeTicks() <= 0 && this.playerData.getMagicCooldownTicks() <= 0 && !this.playerData.getRecharge() && form.canUseMagic() && !this.player.m_21023_((MobEffect)ModMobEffects.KO.get())) {
            PacketHandler.sendToServer(new CSUseShortcutPacket(event.getKey() - 49, lockOn));
        }
    }

    public void loadLists() {
        if (this.playerData != null && this.worldData != null) {
            this.portalCommands = this.worldData.getAllPortalsFromOwnerID(this.player.m_20148_());
            this.magicList = ModConfigs.magicDisplayedInCommandMenu.stream().filter(magic -> this.playerData.getMagicsMap().containsKey(magic)).toList();
            this.limitsList = Utils.getSortedLimits(Utils.getPlayerLimitAttacks((Player)this.player));
            if (this.worldData.getPartyFromMember(this.player.m_20148_()) != null) {
                this.targetsList = this.worldData.getPartyFromMember(this.player.m_20148_()).getMembers();
            }
            this.itemsList = Utils.getEquippedItems(this.playerData.getEquippedItems());
            this.reactionList = this.playerData.getReactionCommands();
        }
    }

    public void playSelectSound() {
        this.playSound((SoundEvent)ModSounds.menu_select.get());
    }

    public void playMoveSound() {
        this.playSound((SoundEvent)ModSounds.menu_move.get());
    }

    public void playBackSound() {
        this.playSound((SoundEvent)ModSounds.menu_back.get());
    }

    public void playInSound() {
        this.playSound((SoundEvent)ModSounds.menu_in.get());
    }

    public void playErrorSound() {
        this.playSound((SoundEvent)ModSounds.error.get());
    }

    public void playSound(SoundEvent sound) {
        this.level.m_6263_((Player)this.player, this.player.m_20182_().m_7096_(), this.player.m_20182_().m_7098_(), this.player.m_20182_().m_7094_(), sound, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public static HitResult getMouseOverExtended(float dist) {
        Minecraft mc = Minecraft.m_91087_();
        Entity theRenderViewEntity = mc.m_91288_();
        if (theRenderViewEntity == null) {
            return null;
        }
        AABB theViewBoundingBox = new AABB(theRenderViewEntity.m_20185_() - 0.5, theRenderViewEntity.m_20186_() - 0.0, theRenderViewEntity.m_20189_() - 0.5, theRenderViewEntity.m_20185_() + 0.5, theRenderViewEntity.m_20186_() + 1.5, theRenderViewEntity.m_20189_() + 0.5);
        HitResult returnMOP = null;
        if (mc.f_91073_ != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.m_19907_(var2, 0.0f, false);
            double calcdist = var2;
            Vec3 pos = theRenderViewEntity.m_20299_(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.m_82450_().m_82554_(pos);
            }
            Vec3 lookvec = theRenderViewEntity.m_20252_(0.0f);
            Vec3 var8 = pos.m_82520_(lookvec.f_82479_ * var2, lookvec.f_82480_ * var2, lookvec.f_82481_ * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.f_91073_.m_45933_(theRenderViewEntity, theViewBoundingBox.m_82377_(lookvec.f_82479_ * var2, lookvec.f_82480_ * var2, lookvec.f_82481_ * var2).m_82377_((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.m_6087_()) continue;
                float bordersize = entity.m_6143_();
                AABB aabb = new AABB(entity.m_20185_() - (double)(entity.m_20205_() / 2.0f), entity.m_20186_(), entity.m_20189_() - (double)(entity.m_20205_() / 2.0f), entity.m_20185_() + (double)(entity.m_20205_() / 2.0f), entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_() + (double)(entity.m_20205_() / 2.0f));
                aabb.m_82377_((double)bordersize, (double)bordersize, (double)bordersize);
                Optional mop0 = aabb.m_82371_(pos, var8);
                if (aabb.m_82390_(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !mop0.isPresent() || !((d1 = pos.m_82554_((Vec3)mop0.get())) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new EntityHitResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    private Keybinds getPressedKey() {
        for (Keybinds key : Keybinds.values()) {
            if (!key.isPressed()) continue;
            return key;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$switchTarget$0(Player player, LivingEntity e) {
        return e != player && !e.m_21224_() && e.m_6084_();
    }

    public static enum Keybinds {
        OPENMENU("key.kingdomkeys.openmenu", 77),
        SCROLL_UP("key.kingdomkeys.scrollup", 265),
        SCROLL_DOWN("key.kingdomkeys.scrolldown", 264),
        ENTER("key.kingdomkeys.enter", 262),
        BACK("key.kingdomkeys.back", 263),
        SCROLL_ACTIVATOR("key.kingdomkeys.scrollactivator", 342),
        SUMMON_KEYBLADE("key.kingdomkeys.summonkeyblade", 71),
        LOCK_ON("key.kingdomkeys.lockon", 90),
        SHOW_GUI("key.kingdomkeys.showgui", 79),
        ACTION("key.kingdomkeys.action", 88),
        SUMMON_ARMOR("key.kingdomkeys.summonarmor", 72),
        REACTION_COMMAND("key.kingdomkeys.reactioncommand", 82);

        public final KeyMapping keybinding;
        public final String translationKey;

        private Keybinds(String name, int defaultKey) {
            this.keybinding = new KeyMapping(name, defaultKey, "key.categories.kingdomkeys");
            this.translationKey = name;
        }

        public KeyMapping getKeybind() {
            return this.keybinding;
        }

        private boolean isPressed() {
            return this.keybinding.m_90859_();
        }
    }
}

