/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;
import org.joml.Vector3f;

public class WayfinderItem
extends Item {
    Player owner;

    public WayfinderItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (stack.m_41783_() != null) {
                if (!stack.m_41783_().m_128403_("ownerUUID")) {
                    stack.m_41751_(this.setID(stack.m_41783_(), player));
                }
            } else {
                stack.m_41751_(this.setID(new CompoundTag(), player));
            }
            if (!worldIn.f_46443_) {
                IPlayerCapabilities playerData;
                if (this.owner == null) {
                    this.owner = this.getOwner((ServerLevel)player.m_9236_(), stack.m_41783_());
                }
                if (this.owner != null && (playerData = ModCapabilities.getPlayer(this.owner)) != null && playerData.getNotifColor() != this.getColor(stack)) {
                    stack.m_41783_().m_128405_("color", playerData.getNotifColor());
                }
            }
            super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)world;
            ItemStack stack = player.m_21120_(hand);
            this.owner = this.getOwner(serverLevel, stack.m_41783_());
            if (this.owner == null) {
                player.m_5661_((Component)Component.m_237110_((String)"message.wayfinder.player_not_found", (Object[])new Object[]{stack.m_41783_().m_128461_("ownerName").toString()}), true);
                return super.m_7203_(world, player, hand);
            }
            Party p = ModCapabilities.getWorld(world).getPartyFromMember(player.m_20148_());
            if (this.owner == player) {
                player.m_5661_((Component)Component.m_237115_((String)"message.wayfinder.your_wayfinder").m_130946_(" ").m_130946_(ModConfigs.wayfinderOnlyParty ? Component.m_237115_((String)"message.wayfinder.in_your_party").getString() : ""), true);
                return super.m_7203_(world, player, hand);
            }
            if (ModConfigs.wayfinderOnlyParty) {
                if (p == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.wayfinder.not_in_party"), true);
                    return super.m_7203_(world, player, hand);
                }
                if (!Utils.isEntityInParty(p, (Entity)player)) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.wayfinder.player_not_in_party", (Object[])new Object[]{stack.m_41783_().m_128461_("ownerName").toString()}), true);
                    return super.m_7203_(world, player, hand);
                }
            }
            this.teleport(player, (Entity)this.owner, this.getColor(player.m_21120_(hand)));
        }
        return super.m_7203_(world, player, hand);
    }

    public void teleport(Player player, Entity owner, int color) {
        if (player.m_9236_().m_46472_() != owner.m_9236_().m_46472_()) {
            ServerLevel destiinationWorld = owner.m_20194_().m_129880_(owner.m_9236_().m_46472_());
            player.changeDimension(destiinationWorld, (ITeleporter)new BaseTeleporter(owner.m_20182_()));
        }
        player.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
        player.m_20334_(0.0, 0.0, 0.0);
        player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.unsummon_armor.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 6.0f), player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), 150, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 6.0f), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 150, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 6.0f), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 150, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 300, 0.0, 0.0, 0.0, 0.2);
        player.m_36335_().m_41524_((Item)this, 6000);
    }

    public CompoundTag setID(CompoundTag nbt, Player player) {
        nbt.m_128362_("ownerUUID", player.m_20148_());
        nbt.m_128359_("ownerName", player.m_5446_().getString());
        nbt.m_128405_("color", Color.WHITE.getRGB());
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (playerData != null) {
            nbt.m_128405_("color", playerData.getNotifColor());
        }
        return nbt;
    }

    public Player getOwner(ServerLevel level, CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        UUID playerUUID = nbt.m_128342_("ownerUUID");
        for (Player p : Utils.getAllPlayers(level.m_7654_())) {
            if (!p.m_20148_().equals(playerUUID)) continue;
            return p;
        }
        return null;
    }

    public int getColor(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Color.WHITE.getRGB();
        }
        return stack.m_41783_().m_128451_("color");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null) {
            tooltip.add((Component)Component.m_237110_((String)"message.wayfinder.owner", (Object[])new Object[]{stack.m_41783_().m_128461_("ownerName").toString()}));
            if (Minecraft.m_91087_().f_91074_.m_36335_().m_41519_((Item)this)) {
                tooltip.add((Component)Component.m_237110_((String)"message.wayfinder.cooldown", (Object[])new Object[]{(int)(Minecraft.m_91087_().f_91074_.m_36335_().m_41521_((Item)this, 0.0f) * 100.0f)}));
            }
        }
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }
}

