/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.leveling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.leveling.Level;
import online.kingdomkeys.kingdomkeys.leveling.LevelingData;
import online.kingdomkeys.kingdomkeys.leveling.LevelingDataDeserializer;
import online.kingdomkeys.kingdomkeys.leveling.ModLevels;

public class LevelingDataLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(LevelingData.class, (Object)new LevelingDataDeserializer()).setPrettyPrinting().create();

    public LevelingDataLoader() {
        super(GSON_BUILDER, "leveling");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        AtomicInteger count = new AtomicInteger();
        objectIn.forEach((resourceLocation, element) -> {
            try {
                if (ModLevels.registry.get().containsKey(resourceLocation)) {
                    Level level = (Level)ModLevels.registry.get().getValue(resourceLocation);
                    LevelingData result = (LevelingData)GSON_BUILDER.fromJson(element, LevelingData.class);
                    level.setLevelingData(result);
                    count.incrementAndGet();
                } else {
                    KingdomKeys.LOGGER.warn("Found level data {} for level that doesn't exist", resourceLocation);
                }
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing level json file {}: {}", resourceLocation, (Object)e);
            }
        });
        KingdomKeys.LOGGER.info("Loaded {} leveling data", (Object)count.get());
    }
}

