/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenEquipmentScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSEquipKeychain {
    ResourceLocation slotToEquipTo;
    int slotToEquipFrom;

    public CSEquipKeychain() {
    }

    public CSEquipKeychain(ResourceLocation slotToEquipTo, int slotToEquipFrom) {
        this.slotToEquipTo = slotToEquipTo;
        this.slotToEquipFrom = slotToEquipFrom;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.slotToEquipTo);
        buffer.writeInt(this.slotToEquipFrom);
    }

    public static CSEquipKeychain decode(FriendlyByteBuf buffer) {
        CSEquipKeychain msg = new CSEquipKeychain();
        msg.slotToEquipTo = buffer.m_130281_();
        msg.slotToEquipFrom = buffer.readInt();
        return msg;
    }

    public static void handle(CSEquipKeychain message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IPlayerCapabilities playerData;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!MinecraftForge.EVENT_BUS.post((Event)new EquipmentEvent.Keychain((Player)player, (playerData = ModCapabilities.getPlayer((Player)player)).getEquippedKeychain(message.slotToEquipTo), player.m_150109_().m_8020_(message.slotToEquipFrom), message.slotToEquipFrom, message.slotToEquipTo))) {
                ItemStack stackToEquip = player.m_150109_().m_8020_(message.slotToEquipFrom);
                ItemStack stackPreviouslyEquipped = playerData.equipKeychain(message.slotToEquipTo, stackToEquip);
                player.m_150109_().m_6836_(message.slotToEquipFrom, stackPreviouslyEquipped);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                PacketHandler.sendTo(new SCOpenEquipmentScreen(), player);
                Utils.RefreshAbilityAttributes((Player)player, playerData);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

