/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSPartyAddMember {
    String name;
    UUID memberUUID;
    String memberName;

    public CSPartyAddMember() {
    }

    public CSPartyAddMember(Party party, Player member) {
        this.name = party.getName();
        this.memberUUID = member.m_20148_();
        this.memberName = member.m_5446_().getString();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.m_130077_(this.memberUUID);
        buffer.writeInt(this.memberName.length());
        buffer.m_130070_(this.memberName);
    }

    public static CSPartyAddMember decode(FriendlyByteBuf buffer) {
        CSPartyAddMember msg = new CSPartyAddMember();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        msg.memberUUID = buffer.m_130259_();
        length = buffer.readInt();
        msg.memberName = buffer.m_130136_(length);
        return msg;
    }

    public static void handle(CSPartyAddMember message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
            for (Party p : worldData.getParties()) {
                if (p.getName().equals(message.name)) {
                    p.addMember(message.memberUUID, message.memberName);
                }
                Player target = player.m_9236_().m_46003_(message.memberUUID);
                ModCapabilities.getPlayer(target).removePartiesInvited(message.name);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(target)), (ServerPlayer)target);
            }
            Utils.syncWorldData(player.m_9236_(), worldData);
        });
        ctx.get().setPacketHandled(true);
    }
}

