/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSPartyDisband {
    String name;
    String username;
    UUID uuid;
    boolean priv;

    public CSPartyDisband() {
    }

    public CSPartyDisband(Party party) {
        this.name = party.getName();
        this.uuid = party.getLeaders().get(0).getUUID();
        this.username = party.getLeaders().get(0).getUsername();
        this.priv = party.getPriv();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.m_130077_(this.uuid);
        buffer.writeInt(this.username.length());
        buffer.m_130070_(this.username);
        buffer.writeBoolean(this.priv);
    }

    public static CSPartyDisband decode(FriendlyByteBuf buffer) {
        CSPartyDisband msg = new CSPartyDisband();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        msg.uuid = buffer.m_130259_();
        length = buffer.readInt();
        msg.username = buffer.m_130136_(length);
        msg.priv = buffer.readBoolean();
        return msg;
    }

    public static void handle(CSPartyDisband message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
            Party p = worldData.getPartyFromName(message.name);
            if (p != null) {
                worldData.removeParty(p);
            }
            Utils.syncWorldData(player.m_9236_(), worldData);
        });
        ctx.get().setPacketHandled(true);
    }
}

