/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class CSPartyInvite {
    String name;
    UUID playerUUID;

    public CSPartyInvite() {
    }

    public CSPartyInvite(Party party, UUID playerUUID) {
        this.name = party.getName();
        this.playerUUID = playerUUID;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.m_130077_(this.playerUUID);
    }

    public static CSPartyInvite decode(FriendlyByteBuf buffer) {
        CSPartyInvite msg = new CSPartyInvite();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        msg.playerUUID = buffer.m_130259_();
        return msg;
    }

    public static void handle(CSPartyInvite message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Player target = player.m_9236_().m_46003_(message.playerUUID);
            IPlayerCapabilities targetPlayerData = ModCapabilities.getPlayer(target);
            if (!targetPlayerData.getPartiesInvited().contains(message.name)) {
                targetPlayerData.addPartiesInvited(message.name);
                IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
                Party p = worldData.getPartyFromName(message.name);
                target.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.YELLOW) + "You got an invitation to " + p.getName())));
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket(targetPlayerData), (ServerPlayer)target);
        });
        ctx.get().setPacketHandled(true);
    }
}

