/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;

public class CSPedestalConfig {
    private BlockPos tileEntityPos;
    private float rotationSpeed;
    private float bobSpeed;
    private float savedRotation;
    private float savedHeight;
    private float baseHeight;
    private float scale;
    private boolean pause;
    private boolean flipped;

    public CSPedestalConfig() {
    }

    public CSPedestalConfig(BlockPos tileEntityPos, float rotationSpeed, float bobSpeed, float savedRotation, float savedHeight, float baseHeight, float scale, boolean pause, boolean flipped) {
        this.tileEntityPos = tileEntityPos;
        this.rotationSpeed = rotationSpeed;
        this.bobSpeed = bobSpeed;
        this.savedRotation = savedRotation;
        this.savedHeight = savedHeight;
        this.baseHeight = baseHeight;
        this.scale = scale;
        this.pause = pause;
        this.flipped = flipped;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.tileEntityPos);
        buffer.writeFloat(this.rotationSpeed);
        buffer.writeFloat(this.bobSpeed);
        buffer.writeFloat(this.savedRotation);
        buffer.writeFloat(this.savedHeight);
        buffer.writeFloat(this.baseHeight);
        buffer.writeFloat(this.scale);
        buffer.writeBoolean(this.pause);
        buffer.writeBoolean(this.flipped);
    }

    public static CSPedestalConfig decode(FriendlyByteBuf buffer) {
        CSPedestalConfig msg = new CSPedestalConfig();
        msg.tileEntityPos = buffer.m_130135_();
        msg.rotationSpeed = buffer.readFloat();
        msg.bobSpeed = buffer.readFloat();
        msg.savedRotation = buffer.readFloat();
        msg.savedHeight = buffer.readFloat();
        msg.baseHeight = buffer.readFloat();
        msg.scale = buffer.readFloat();
        msg.pause = buffer.readBoolean();
        msg.flipped = buffer.readBoolean();
        return msg;
    }

    public static void handle(CSPedestalConfig message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            PedestalTileEntity tileEntity = (PedestalTileEntity)world.m_7702_(message.tileEntityPos);
            tileEntity.setSpeed(message.rotationSpeed, message.bobSpeed);
            tileEntity.saveTransforms(message.savedRotation, message.savedHeight);
            tileEntity.setScale(message.scale);
            tileEntity.setPause(message.pause);
            tileEntity.setFlipped(message.flipped);
            tileEntity.setBaseHeight(message.baseHeight);
            world.m_7260_(message.tileEntityPos, world.m_8055_(message.tileEntityPos), world.m_8055_(message.tileEntityPos), 2);
        });
        ctx.get().setPacketHandled(true);
    }
}

