/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.api.event.ChoiceEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class CSSetChoice {
    SoAState state;
    SoAState choice;
    BlockPos pedestal;
    boolean confirm = false;

    public CSSetChoice() {
    }

    public CSSetChoice(SoAState state, SoAState choice, BlockPos pedestal) {
        this.state = state;
        this.choice = choice;
        this.pedestal = pedestal;
    }

    public CSSetChoice(SoAState state, boolean confirm) {
        this(state, SoAState.NONE, null);
        this.confirm = confirm;
        this.pedestal = new BlockPos(0, 0, 0);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeByte((int)this.state.get());
        buffer.writeByte((int)this.choice.get());
        buffer.writeBoolean(this.confirm);
        buffer.m_130064_(this.pedestal);
    }

    public static CSSetChoice decode(FriendlyByteBuf buffer) {
        CSSetChoice msg = new CSSetChoice();
        msg.state = SoAState.fromByte(buffer.readByte());
        msg.choice = SoAState.fromByte(buffer.readByte());
        msg.confirm = buffer.readBoolean();
        msg.pedestal = buffer.m_130135_();
        return msg;
    }

    public static void handle(CSSetChoice message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            if (message.state == SoAState.CONFIRM) {
                if (message.confirm) {
                    playerData.setSoAState(SoAState.COMPLETE);
                    ServerLevel dimension = player.m_9236_().m_7654_().m_129880_(playerData.getReturnDimension());
                    player.changeDimension(dimension, (ITeleporter)new BaseTeleporter(playerData.getReturnLocation()));
                    SoAState.applyStatsForChoices((Player)player, playerData, false);
                    MinecraftForge.EVENT_BUS.post((Event)new ChoiceEvent((Player)player, playerData.getChosen(), playerData.getSacrificed()));
                } else {
                    playerData.setChoicePedestal(new BlockPos(0, 0, 0));
                    playerData.setSacrificePedestal(new BlockPos(0, 0, 0));
                    playerData.setChoice(SoAState.NONE);
                    playerData.setSacrifice(SoAState.NONE);
                    playerData.setSoAState(SoAState.CHOICE);
                }
            } else if (message.state == SoAState.CHOICE) {
                playerData.setChoicePedestal(message.pedestal);
                playerData.setChoice(message.choice);
                playerData.setSoAState(SoAState.SACRIFICE);
            } else if (message.state == SoAState.SACRIFICE) {
                playerData.setSacrificePedestal(message.pedestal);
                playerData.setSacrifice(message.choice);
                playerData.setSoAState(SoAState.CONFIRM);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

