/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.OrgPortalEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrgPortalPacket;

public class CSSpawnOrgPortalPacket {
    BlockPos pos;
    BlockPos destPos;
    ResourceKey<Level> dimension;

    public CSSpawnOrgPortalPacket() {
    }

    public CSSpawnOrgPortalPacket(BlockPos pos, BlockPos dest, ResourceKey<Level> dim) {
        this.pos = pos;
        this.destPos = dest;
        this.dimension = dim;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130064_(this.destPos);
        buffer.m_130085_(this.dimension.m_135782_());
    }

    public static CSSpawnOrgPortalPacket decode(FriendlyByteBuf buffer) {
        CSSpawnOrgPortalPacket msg = new CSSpawnOrgPortalPacket();
        msg.pos = buffer.m_130135_();
        msg.destPos = buffer.m_130135_();
        msg.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
        return msg;
    }

    public static void handle(CSSpawnOrgPortalPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            player.m_9236_().m_5594_(null, message.pos, (SoundEvent)ModSounds.portal.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            player.m_9236_().m_5594_(null, message.destPos, (SoundEvent)ModSounds.portal.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.remMP(300.0);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
            OrgPortalEntity portal = new OrgPortalEntity(player.m_9236_(), message.pos, message.destPos, message.dimension, true);
            player.m_9236_().m_7967_((Entity)portal);
            OrgPortalEntity destPortal = new OrgPortalEntity(player.m_9236_(), message.destPos.m_7494_(), message.destPos, message.dimension, false);
            player.m_9236_().m_7967_((Entity)destPortal);
            PacketHandler.sendToAllPlayers(new SCSyncOrgPortalPacket(message.pos, message.destPos, message.dimension));
        });
        ctx.get().setPacketHandled(true);
    }
}

