/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSUseMagicPacket {
    String name;
    String allyTarget;
    int level;
    int lockedTarget;

    public CSUseMagicPacket() {
    }

    public CSUseMagicPacket(String name, int level, LivingEntity lockedTarget) {
        this.name = name;
        this.allyTarget = "";
        this.level = level;
        this.lockedTarget = lockedTarget == null ? -1 : lockedTarget.m_19879_();
    }

    public CSUseMagicPacket(String name, String target, int level) {
        this.name = name;
        this.allyTarget = target;
        this.level = level;
        this.lockedTarget = -1;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.writeInt(this.allyTarget.length());
        buffer.m_130070_(this.allyTarget);
        buffer.writeInt(this.level);
        buffer.writeInt(this.lockedTarget);
    }

    public static CSUseMagicPacket decode(FriendlyByteBuf buffer) {
        CSUseMagicPacket msg = new CSUseMagicPacket();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        length = buffer.readInt();
        msg.allyTarget = buffer.m_130136_(length);
        msg.level = buffer.readInt();
        msg.lockedTarget = buffer.readInt();
        return msg;
    }

    public static void handle(CSUseMagicPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            if (playerData.getMP() >= 0.0 && !playerData.getRecharge()) {
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                if (message.allyTarget.equals("")) {
                    if (message.lockedTarget > -1) {
                        ((Magic)ModMagic.registry.get().getValue(new ResourceLocation(message.name))).onUse((Player)player, (Player)player, message.level, (LivingEntity)player.m_9236_().m_6815_(message.lockedTarget));
                    } else {
                        ((Magic)ModMagic.registry.get().getValue(new ResourceLocation(message.name))).onUse((Player)player, (Player)player, message.level, null);
                    }
                } else {
                    Player allyTargetEntity = Utils.getPlayerByName(player.m_9236_(), message.allyTarget.toLowerCase());
                    ((Magic)ModMagic.registry.get().getValue(new ResourceLocation(message.name))).onUse(allyTargetEntity, (Player)player, message.level, null);
                }
            }
            PacketHandler.syncToAllAround((Player)player, playerData);
        });
        ctx.get().setPacketHandled(true);
    }
}

