/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.lib.SoAState;

public class SCOpenChoiceScreen {
    public SoAState choice;
    public SoAState state;
    public BlockPos pos;

    public SCOpenChoiceScreen() {
    }

    public SCOpenChoiceScreen(ItemStack choiceItem, SoAState state, BlockPos pos) {
        this.choice = choiceItem.m_41720_() == ModItems.dreamSword.get() ? SoAState.WARRIOR : (choiceItem.m_41720_() == ModItems.dreamShield.get() ? SoAState.GUARDIAN : (choiceItem.m_41720_() == ModItems.dreamStaff.get() ? SoAState.MYSTIC : SoAState.NONE));
        this.state = state;
        this.pos = pos;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeByte((int)this.choice.get());
        buffer.writeByte((int)this.state.get());
        buffer.m_130064_(this.pos);
    }

    public static SCOpenChoiceScreen decode(FriendlyByteBuf buffer) {
        SCOpenChoiceScreen msg = new SCOpenChoiceScreen();
        msg.choice = SoAState.fromByte(buffer.readByte());
        msg.state = SoAState.fromByte(buffer.readByte());
        msg.pos = buffer.m_130135_();
        return msg;
    }

    public static void handle(SCOpenChoiceScreen message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SCOpenChoiceScreen message) {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.openChoice(message));
        }
    }
}

