/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.GlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SCSyncGlobalCapabilityToAllPacket {
    int id;
    private int level;
    private int stopModelTicks;
    private ArrayList<Float> stopDmg = new ArrayList();
    private boolean castleOblivionMarker;

    public SCSyncGlobalCapabilityToAllPacket() {
    }

    public SCSyncGlobalCapabilityToAllPacket(int id, IGlobalCapabilities capability) {
        this.id = id;
        this.stopDmg = capability.getStopDamage();
        this.castleOblivionMarker = capability.getCastleOblivionMarker();
        this.level = capability.getLevel();
        this.stopModelTicks = capability.getStopModelTicks();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeInt(this.stopDmg.size());
        for (Float unit : this.stopDmg) {
            buffer.writeFloat(unit.floatValue());
        }
        buffer.writeBoolean(this.castleOblivionMarker);
        buffer.writeInt(this.level);
        buffer.writeInt(this.stopModelTicks);
    }

    public static SCSyncGlobalCapabilityToAllPacket decode(FriendlyByteBuf buffer) {
        SCSyncGlobalCapabilityToAllPacket msg = new SCSyncGlobalCapabilityToAllPacket();
        msg.id = buffer.readInt();
        int len = buffer.readInt();
        for (int i = 0; i < len; ++i) {
            msg.stopDmg.add(Float.valueOf(buffer.readFloat()));
        }
        msg.castleOblivionMarker = buffer.readBoolean();
        msg.level = buffer.readInt();
        msg.stopModelTicks = buffer.readInt();
        return msg;
    }

    public static void handle(SCSyncGlobalCapabilityToAllPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LivingEntity entity = (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(message.id);
            GlobalCapabilities cache = new GlobalCapabilities();
            cache.setStopDamage(message.stopDmg);
            cache.setCastleOblivionMarker(message.castleOblivionMarker);
            cache.setLevel(message.level);
            cache.setStopModelTicks(message.stopModelTicks);
            if (message.id != Minecraft.m_91087_().f_91074_.m_19879_()) {
                ModCapabilities.mobDataClientCache.put(message.id, cache);
            }
            if (entity != null) {
                LazyOptional globalData = entity.getCapability(ModCapabilities.GLOBAL_CAPABILITIES);
                globalData.ifPresent(cap -> {
                    cap.setStopDamage(message.stopDmg);
                    cap.setCastleOblivionMarker(message.castleOblivionMarker);
                    cap.setLevel(message.level);
                    cap.setStopModelTicks(message.stopModelTicks);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

