/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.reactioncommands;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.AbilityEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.Utils;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class ReactionAutoForm
extends ReactionCommand {
    String form;
    String abilityName;

    public ReactionAutoForm(String registryName, String abilityName, String form) {
        super(registryName, true);
        this.form = form;
        this.abilityName = abilityName;
    }

    public String getFormName() {
        return this.form;
    }

    public String getAbilityName() {
        return this.abilityName;
    }

    public DriveForm getForm() {
        return (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.form));
    }

    public boolean isAutoForm() {
        return this.form != null;
    }

    @Override
    public void onUse(Player player, LivingEntity target, LivingEntity lockOnEntity) {
        if (this.conditionsToAppear(player, target)) {
            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.drive.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && this.form.equals(DriveForm.NONE.toString())) {
                forma = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
                forma.endDrive(player);
                if (!forma.getBaseGrowthAbilities()) {
                    MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Unequip((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(forma.getDFAbilityForLevel(playerData.getDriveFormLevel(forma.getName())))), playerData.getDriveFormLevel(forma.getName()), player, false));
                }
                for (String abilityLoc : forma.getDriveFormData().getAbilities()) {
                    ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityLoc));
                    MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Equip(ability, 0, player, false));
                }
            } else if (!this.form.equals(DriveForm.NONE.toString())) {
                forma = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.form));
                forma.initDrive(player);
                if (!forma.getBaseGrowthAbilities()) {
                    MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Equip((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(forma.getDFAbilityForLevel(playerData.getDriveFormLevel(forma.getName())))), playerData.getDriveFormLevel(forma.getName()), player, false));
                }
                for (String abilityLoc : forma.getDriveFormData().getAbilities()) {
                    ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityLoc));
                    MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Equip(ability, 0, player, false));
                }
            }
            playerData.removeReactionCommand(this.getRegistryName().toString());
            ArrayList<ReactionCommand> list = new ArrayList<ReactionCommand>();
            for (String name : playerData.getReactionCommands()) {
                ReactionCommand rc = (ReactionCommand)ModReactionCommands.registry.get().getValue(new ResourceLocation(name));
                if (!(rc instanceof ReactionAutoForm)) continue;
                list.add(rc);
            }
            for (ReactionCommand rc : list) {
                if (!(rc instanceof ReactionAutoForm)) continue;
                playerData.removeReactionCommand(rc.getName());
            }
        }
    }

    @Override
    public boolean conditionsToAppear(Player player, LivingEntity target) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (playerData != null && Utils.isPlayerLowHP(player) && playerData.getAlignment() == Utils.OrgMember.NONE && playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            ResourceLocation resourceLocation = new ResourceLocation(this.form);
            if (playerData.getDP() >= (double)((DriveForm)ModDriveForms.registry.get().getValue(resourceLocation)).getDriveCost() && playerData.getEquippedAbilityLevel(this.abilityName)[1] > 0) {
                return true;
            }
        }
        return false;
    }
}

