/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.reactioncommands;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;

public abstract class ReactionCommand {
    ResourceLocation name;
    String translationKey;
    boolean constantCheck;

    public ReactionCommand(ResourceLocation registryName, boolean constantCheck) {
        this.name = registryName;
        this.constantCheck = constantCheck;
        this.translationKey = "reactioncommand." + registryName.m_135827_() + "." + registryName.m_135815_() + ".name";
    }

    public ReactionCommand(String registryName, boolean constantCheck) {
        this(new ResourceLocation(registryName), constantCheck);
    }

    public SoundEvent getUseSound(Player player, LivingEntity target) {
        return (SoundEvent)ModSounds.menu_in.get();
    }

    public String getName() {
        return this.name.toString();
    }

    public boolean needsConstantCheck() {
        return this.constantCheck;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTranslationKey() {
        return this.translationKey;
    }

    public abstract void onUse(Player var1, LivingEntity var2, LivingEntity var3);

    public abstract boolean conditionsToAppear(Player var1, LivingEntity var2);

    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

