/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.keybladeforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncKeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataDeserializer;

public class KeybladeDataLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(KeybladeData.class, (Object)new KeybladeDataDeserializer()).create();
    public static List<String> names = new LinkedList<String>();
    public static List<String> dataList = new LinkedList<String>();

    public KeybladeDataLoader() {
        super(GSON_BUILDER, "keyblades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        names.clear();
        dataList.clear();
        AtomicInteger count = new AtomicInteger();
        objectIn.forEach((resourceLocation, element) -> {
            try {
                if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
                    try {
                        KeybladeItem keyblade = (KeybladeItem)ForgeRegistries.ITEMS.getValue(resourceLocation);
                        KeybladeData result = (KeybladeData)GSON_BUILDER.fromJson(element, KeybladeData.class);
                        dataList.add(element.toString());
                        names.add(resourceLocation.toString());
                        keyblade.setKeybladeData(result);
                        if (result.keychain != null) {
                            result.keychain.setKeyblade(keyblade);
                        }
                        count.incrementAndGet();
                    }
                    catch (ClassCastException e) {
                        KingdomKeys.LOGGER.warn("Keyblade data for non keyblade found {}", resourceLocation);
                    }
                } else {
                    KingdomKeys.LOGGER.warn("Found keyblade data {} for keyblade that doesn't exist", resourceLocation);
                }
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing json file {}: {}", resourceLocation, (Object)e);
            }
        });
        KingdomKeys.LOGGER.info("Loaded {} keyblades data", (Object)count.get());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                PacketHandler.sendTo(new SCSyncKeybladeData(names, dataList), player);
            }
        }
    }
}

