/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop.names;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMoogleNames;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;

public class NamesListLoader {

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Loader
    extends SimpleJsonResourceReloadListener {
        private static final Type stringList = new TypeToken<List<String>>(){}.getType();
        public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(stringList, (json, typeOfT, context) -> json.getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList()).setPrettyPrinting().create();

        public Loader() {
            super(GSON_BUILDER, "shop/names");
        }

        protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
            NamesListRegistry.getInstance().clearRegistry();
            AtomicInteger count = new AtomicInteger();
            pObject.forEach((resourceLocation, element) -> {
                try {
                    List result = (List)GSON_BUILDER.fromJson(element, stringList);
                    NamesListRegistry.getInstance().register((ResourceLocation)resourceLocation, result);
                    count.incrementAndGet();
                }
                catch (JsonParseException e) {
                    KingdomKeys.LOGGER.error("Error parsing json file {}: {}", resourceLocation, (Object)e);
                }
            });
            KingdomKeys.LOGGER.info("Loaded {} shop/names data", (Object)count.get());
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                    PacketHandler.sendTo(new SCSyncMoogleNames(NamesListRegistry.getInstance()), player);
                }
            }
        }
    }
}

