/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncJsonRegistry;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistryObject;

public class JsonRegistry<T extends JsonRegistryObject>
extends SimpleJsonResourceReloadListener {
    private final ResourceLocation registryName;
    private Map<ResourceLocation, T> registry;
    private final String folder;
    private final T emptyValue;
    private final JsonDeserializer<T> deserializer;
    private final Class<T> clazz;

    public JsonRegistry(ResourceLocation registryName, String folder, JsonDeserializer<T> deserializer, Class<T> clazz, T emptyValue) {
        super(new GsonBuilder().registerTypeAdapter(clazz, deserializer).setPrettyPrinting().create(), folder);
        this.registryName = registryName;
        this.registry = new HashMap<ResourceLocation, T>();
        this.folder = folder;
        this.emptyValue = emptyValue;
        this.deserializer = deserializer;
        this.clazz = clazz;
    }

    public JsonRegistry(ResourceLocation registryName, String folder, JsonDeserializer<T> deserializer, Class<T> clazz) {
        this(registryName, folder, deserializer, clazz, null);
    }

    private void register(ResourceLocation key, T value) {
        if (this.registry.containsKey(key)) {
            KingdomKeys.LOGGER.error("Tried to register existing object {} for json registry {}", (Object)key, (Object)this.registryName);
        } else {
            KingdomKeys.LOGGER.debug("{}: registered {}", (Object)this.registryName, (Object)key.toString());
            this.registry.put(key, value);
        }
    }

    public T getValue(ResourceLocation key) {
        if (this.containsKey(key)) {
            return (T)((JsonRegistryObject)this.registry.get(key));
        }
        return this.emptyValue;
    }

    public Collection<T> getValues() {
        return this.registry.values();
    }

    public boolean containsKey(ResourceLocation key) {
        return this.registry.containsKey(key);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.registry = new HashMap<ResourceLocation, T>();
        AtomicInteger count = new AtomicInteger();
        pObject.forEach((resourceLocation, jsonElement) -> {
            JsonRegistryObject result = (JsonRegistryObject)new GsonBuilder().registerTypeAdapter(this.clazz, this.deserializer).setPrettyPrinting().create().fromJson(jsonElement, this.clazz);
            result.registryName = resourceLocation;
            this.register((ResourceLocation)resourceLocation, (T)result);
            count.incrementAndGet();
        });
        KingdomKeys.LOGGER.info("Loaded {} {} data", (Object)count.get(), (Object)this.registryName);
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                PacketHandler.sendTo(new SCSyncJsonRegistry(this), player);
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.registry.forEach((key, value) -> tag.m_128365_(key.toString(), value.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.registry = new HashMap<ResourceLocation, T>();
        tag.m_128431_().forEach(key -> {
            ResourceLocation rl = new ResourceLocation(key);
            try {
                JsonRegistryObject value = (JsonRegistryObject)this.clazz.getDeclaredConstructor(CompoundTag.class).newInstance(tag.m_128469_(key));
                value.registryName = rl;
                this.registry.put(rl, value);
            }
            catch (NoSuchMethodException e) {
                KingdomKeys.LOGGER.error("Deserialization constructor is missing for type {}", (Object)this.clazz.toString());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

