/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomStructures;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomStructure;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.modifiers.RoomModifier;

public class Room
implements INBTSerializable<CompoundTag> {
    RoomType type;
    RoomStructure structure;
    BlockPos position;
    int mobsRemaining;
    public Map<RoomDirection, Door> doors;
    public int parentFloor;
    RoomPos roomPos;
    boolean generated;

    public Room(RoomType type, int parentFloor, RoomPos roomPos) {
        this.type = type;
        this.parentFloor = parentFloor;
        this.doors = new HashMap<RoomDirection, Door>();
        this.roomPos = roomPos;
    }

    public Room(CompoundTag tag) {
        this(ModRoomTypes.registry.get().getValue(new ResourceLocation(tag.m_128461_("type"))), tag.m_128451_("parent"), new RoomPos(tag.m_128469_("room_pos")));
        this.deserializeNBT(tag);
    }

    public RoomStructure getStructure() {
        return this.structure;
    }

    public void setStructure(RoomStructure structure) {
        this.structure = structure;
    }

    public void createRoomFromCard(RoomType type, Level level, Room currentRoom, RoomDirection doorDirection) {
        this.type = type;
        if (this.generated) {
            this.clearRoom(level);
        }
        Direction dir = doorDirection.toMCDirection();
        this.position = currentRoom.position.m_5484_(dir, 128);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    public BlockPos getExitDoor() {
        for (Door door : this.doors.values()) {
            if (door.data.getType() != DoorData.Type.EXIT) continue;
            return door.pos;
        }
        return null;
    }

    public CardDoorTileEntity getDoorTE(Level level, RoomDirection direction) {
        BlockPos pos;
        if (this.doors.containsKey((Object)direction) && (pos = this.doors.get((Object)direction).pos()) != null) {
            return (CardDoorTileEntity)level.m_7702_(pos);
        }
        return null;
    }

    public RoomType getType() {
        return this.type;
    }

    public RoomPos getRoomPos() {
        return this.roomPos;
    }

    public RoomData getRoomData(Level level) {
        return this.getParent(level).getRoom(this.getRoomPos());
    }

    public Floor getParent(Level level) {
        return ModCapabilities.getCastleOblivionInterior(level).getFloorByID(this.parentFloor);
    }

    public void tick() {
        this.type.getModifiers().forEach(RoomModifier::tick);
    }

    public boolean inRoom(BlockPos pos) {
        return pos.m_123341_() >= this.position.m_123341_() && pos.m_123341_() <= this.position.m_123341_() + this.structure.getWidth() && pos.m_123343_() >= this.position.m_123343_() && pos.m_123343_() <= this.position.m_123343_() + this.structure.getDepth();
    }

    public boolean clearRoom(Level level) {
        Floor parent = this.getParent(level);
        if (parent != null) {
            if (!parent.shouldRoomTick(this)) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.position.m_123341_(), this.position.m_123342_(), this.position.m_123343_());
                for (int z = 0; z < this.structure.getDepth(); ++z) {
                    for (int y = 0; y < 128; ++y) {
                        for (int x = 0; x < this.structure.getWidth(); ++x) {
                            pos.m_122178_(x, y, z);
                            level.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 2);
                        }
                    }
                }
                this.generated = false;
                return true;
            }
            return false;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("parent", this.parentFloor);
        tag.m_128365_("room_pos", (Tag)this.roomPos.serializeNBT());
        tag.m_128359_("type", this.type.getRegistryName().toString());
        tag.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)this.position));
        tag.m_128405_("mobs", this.mobsRemaining);
        tag.m_128379_("generated", this.generated);
        tag.m_128405_("door_positions_size", this.doors.size());
        CompoundTag doorPosTag = new CompoundTag();
        int i = 0;
        for (Map.Entry<RoomDirection, Door> doorPos : this.doors.entrySet()) {
            doorPosTag.m_128405_("direction_" + i, doorPos.getKey().ordinal());
            doorPosTag.m_128365_("door_" + i, (Tag)doorPos.getValue().serializeNBT());
            ++i;
        }
        tag.m_128365_("door_positions", (Tag)doorPosTag);
        tag.m_128359_("structure", this.structure.getRegistryName().toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.position = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("position"));
        this.mobsRemaining = tag.m_128451_("mobs");
        this.generated = tag.m_128471_("generated");
        int doorPosSize = tag.m_128451_("door_positions_size");
        CompoundTag doorPosTag = tag.m_128469_("door_positions");
        for (int i = 0; i < doorPosSize; ++i) {
            this.doors.put(RoomDirection.values()[doorPosTag.m_128451_("direction_" + i)], new Door(doorPosTag.m_128469_("door_" + i)));
        }
        this.structure = ModRoomStructures.registry.get().getValue(new ResourceLocation(tag.m_128461_("structure")));
    }

    public record Door(DoorData data, BlockPos pos) {
        public Door(CompoundTag tag) {
            this(new DoorData(tag.m_128469_("data")), NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos")));
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("data", (Tag)this.data.serializeNBT());
            tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
            return tag;
        }
    }
}

