/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.CastleOblivionCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorCapability;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.CastleOblivionEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomStructures;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomStructure;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;
import org.jetbrains.annotations.Nullable;

public class RoomGenerator {
    public static final RoomGenerator INSTANCE = new RoomGenerator();

    private RoomGenerator() {
    }

    public Room generateNewFloor(Level level) {
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(level);
        Floor currentFloor = new Floor(level);
        Room room = new Room(ModRoomTypes.ENTRANCE_HALL.get(), currentFloor.getFloorID(), RoomPos.ZERO);
        Floor prevFloor = cap.getFloorByID(currentFloor.getFloorID() - 1);
        room.setPosition(prevFloor.getNorthernMostRoomPosition().m_5484_(Direction.SOUTH, 512));
        return this.generateRoom(level, currentFloor.getRoom(RoomPos.ZERO), room, null);
    }

    public Room generateRoom(Level level, RoomData data, RoomType type, @Nullable Room currentRoom, @Nullable RoomDirection doorDirection) {
        if (type.equals(ModRoomTypes.ENTRANCE_HALL.get()) && data.pos.equals(RoomPos.ZERO)) {
            KingdomKeys.LOGGER.warn("Tried to generate room type {} at entrance hall position", (Object)type.getRegistryName().toString());
            return null;
        }
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(level);
        Floor currentFloor = cap.getFloorByID(currentRoom.parentFloor);
        Room room = new Room(type, currentFloor.getFloorID(), data.pos);
        room.createRoomFromCard(type, level, currentRoom, doorDirection);
        return this.generateRoom(level, data, room, currentRoom);
    }

    private Room generateRoom(Level level, RoomData data, Room newRoom, @Nullable Room currentRoom) {
        try {
            int i;
            CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(level);
            Floor currentFloor = cap.getFloorByID(newRoom.parentFloor);
            BlockPos pos = newRoom.position;
            List<RoomStructure> possibleRooms = ModRoomStructures.getCompatibleStructures(currentFloor.getType(), newRoom.type);
            if (possibleRooms.isEmpty()) {
                throw new IOException(String.format("No compatible room structure files found for %s", newRoom.type.getRegistryName()));
            }
            RoomStructure structureToGenerate = possibleRooms.get(Utils.randomWithRange(0, possibleRooms.size() - 1));
            String floorFolder = structureToGenerate.getFloor() == null ? "all" : structureToGenerate.getFloor().getRegistryName().m_135815_();
            Resource resource = (Resource)level.m_7654_().m_177941_().m_213713_(new ResourceLocation("kingdomkeys", "structures/castle_oblivion/rooms/" + floorFolder + "/" + structureToGenerate.getPath() + ".nbt")).get();
            CompoundTag main = NbtIo.m_128939_((InputStream)resource.m_215507_());
            newRoom.setStructure(structureToGenerate);
            ListTag palette = main.m_128437_("palette", 10);
            ListTag blocks = main.m_128437_("blocks", 10);
            ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
            CompoundTag block = blocks.m_128728_(0);
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(block.m_128437_("pos", 3).m_128763_(0), block.m_128437_("pos", 3).m_128763_(1), block.m_128437_("pos", 3).m_128763_(2));
            for (i = 0; i < palette.size(); ++i) {
                block = palette.m_128728_(i);
                blockStates.add(NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)block));
            }
            for (i = 0; i < blocks.size(); ++i) {
                block = blocks.m_128728_(i);
                blockpos.m_122178_(block.m_128437_("pos", 3).m_128763_(0) + pos.m_123341_(), block.m_128437_("pos", 3).m_128763_(1) + pos.m_123342_(), block.m_128437_("pos", 3).m_128763_(2) + pos.m_123343_());
                BlockState state = (BlockState)blockStates.get(block.m_128451_("state"));
                if (state.m_60734_() == Blocks.f_50677_) {
                    RoomDirection facing;
                    if (!((StructureMode)state.m_61143_((Property)StructureBlock.f_57110_)).equals((Object)StructureMode.DATA)) continue;
                    StructureBlockEntity be = new StructureBlockEntity((BlockPos)blockpos, state);
                    be.m_142466_(block.m_128469_("nbt"));
                    BlockState cardDoorState = (BlockState)((Block)ModBlocks.cardDoor.get()).m_49966_().m_61124_((Property)CardDoorBlock.GENERATED, (Comparable)Boolean.valueOf(true));
                    switch (be.m_59907_()) {
                        case "north": {
                            RoomDirection roomDirection = RoomDirection.SOUTH;
                            break;
                        }
                        case "west": {
                            RoomDirection roomDirection = RoomDirection.EAST;
                            break;
                        }
                        case "east": {
                            RoomDirection roomDirection = RoomDirection.WEST;
                            break;
                        }
                        case "south": {
                            RoomDirection roomDirection = RoomDirection.NORTH;
                            break;
                        }
                        default: {
                            RoomDirection roomDirection = facing = null;
                        }
                    }
                    if (facing == null) continue;
                    cardDoorState = (BlockState)cardDoorState.m_61124_((Property)CardDoorBlock.FACING, (Comparable)facing.toMCDirection().m_122424_());
                    DoorData doorData = data.getDoor(facing);
                    if (doorData != null && doorData.getType() != DoorData.Type.NONE) {
                        BlockPos adjacentDoorPos;
                        CardDoorTileEntity adjacentDoorTE;
                        newRoom.doors.put(facing, new Room.Door(doorData, blockpos.m_7949_()));
                        if (doorData.getType() == DoorData.Type.EXIT || doorData.getType() == DoorData.Type.ENTRANCE) {
                            cardDoorState = (BlockState)cardDoorState.m_61124_((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            level.m_7731_((BlockPos)blockpos, cardDoorState, 2);
                            CardDoorTileEntity cardDoorTileEntity = new CardDoorTileEntity((BlockPos)blockpos, cardDoorState);
                            cardDoorTileEntity.setParent(data);
                            cardDoorTileEntity.setDirection(facing);
                            cardDoorTileEntity.setData(doorData);
                            cardDoorTileEntity.openDoor(false);
                            level.m_151523_((BlockEntity)cardDoorTileEntity);
                            continue;
                        }
                        if (doorData.getType() == DoorData.Type.HALL) {
                            level.m_7731_((BlockPos)blockpos, cardDoorState, 2);
                            CardDoorTileEntity cardDoorTileEntity = new CardDoorTileEntity((BlockPos)blockpos, cardDoorState);
                            cardDoorTileEntity.setParent(data);
                            cardDoorTileEntity.setDirection(facing);
                            cardDoorTileEntity.setData(doorData);
                            level.m_151523_((BlockEntity)cardDoorTileEntity);
                            continue;
                        }
                        RoomData adjacentRoom = currentFloor.getAdjacentRoom(data, facing);
                        if (adjacentRoom == null) continue;
                        if (adjacentRoom.getGenerated() != null && (adjacentDoorTE = (CardDoorTileEntity)level.m_7702_(adjacentDoorPos = adjacentRoom.getGenerated().doors.get((Object)facing.opposite()).pos())) != null && adjacentDoorTE.isOpen()) {
                            cardDoorState = (BlockState)cardDoorState.m_61124_((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            adjacentDoorTE.setDestinationRoom(data);
                        }
                        if (adjacentRoom.getDoors().get((Object)facing.opposite()) == null) continue;
                        level.m_7731_((BlockPos)blockpos, cardDoorState, 2);
                        CardDoorTileEntity cardDoorTileEntity = new CardDoorTileEntity((BlockPos)blockpos, cardDoorState);
                        cardDoorTileEntity.setParent(data);
                        cardDoorTileEntity.setDirection(facing);
                        cardDoorTileEntity.setDestinationRoom(adjacentRoom);
                        cardDoorTileEntity.setData(doorData);
                        cardDoorTileEntity.openDoor(false);
                        level.m_151523_((BlockEntity)cardDoorTileEntity);
                        continue;
                    }
                    level.m_7731_((BlockPos)blockpos, Blocks.f_50016_.m_49966_(), 2);
                    continue;
                }
                level.m_7731_((BlockPos)blockpos, state, 2);
            }
            data.setGenerated(newRoom);
            SCSyncCastleOblivionInteriorCapability.syncClients(level);
            KingdomKeys.LOGGER.info("Generated room:{} at {}", (Object)newRoom.type.getRegistryName().toString(), (Object)pos);
            MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.RoomGeneratedEvent(level, data, currentRoom));
            return newRoom;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

